package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Username
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnableUserRequest(
    userName: Username,
    authenticationType: zio.aws.appstream.model.AuthenticationType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.EnableUserRequest = {
    import EnableUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.EnableUserRequest
      .builder()
      .userName(Username.unwrap(userName): java.lang.String)
      .authenticationType(authenticationType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.EnableUserRequest.ReadOnly =
    zio.aws.appstream.model.EnableUserRequest.wrap(buildAwsValue())
}
object EnableUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.EnableUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.EnableUserRequest =
      zio.aws.appstream.model.EnableUserRequest(userName, authenticationType)
    def userName: Username
    def authenticationType: zio.aws.appstream.model.AuthenticationType
    def getUserName: ZIO[Any, Nothing, Username] = ZIO.succeed(userName)
    def getAuthenticationType
        : ZIO[Any, Nothing, zio.aws.appstream.model.AuthenticationType] =
      ZIO.succeed(authenticationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.EnableUserRequest
  ) extends zio.aws.appstream.model.EnableUserRequest.ReadOnly {
    override val userName: Username =
      zio.aws.appstream.model.primitives.Username(impl.userName())
    override val authenticationType
        : zio.aws.appstream.model.AuthenticationType =
      zio.aws.appstream.model.AuthenticationType.wrap(impl.authenticationType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.EnableUserRequest
  ): zio.aws.appstream.model.EnableUserRequest.ReadOnly = new Wrapper(impl)
}
