package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Name
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateApplicationFromEntitlementRequest(
    stackName: Name,
    entitlementName: Name,
    applicationIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DisassociateApplicationFromEntitlementRequest = {
    import DisassociateApplicationFromEntitlementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DisassociateApplicationFromEntitlementRequest
      .builder()
      .stackName(Name.unwrap(stackName): java.lang.String)
      .entitlementName(Name.unwrap(entitlementName): java.lang.String)
      .applicationIdentifier(applicationIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DisassociateApplicationFromEntitlementRequest.ReadOnly =
    zio.aws.appstream.model.DisassociateApplicationFromEntitlementRequest
      .wrap(buildAwsValue())
}
object DisassociateApplicationFromEntitlementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DisassociateApplicationFromEntitlementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appstream.model.DisassociateApplicationFromEntitlementRequest =
      zio.aws.appstream.model.DisassociateApplicationFromEntitlementRequest(
        stackName,
        entitlementName,
        applicationIdentifier
      )
    def stackName: Name
    def entitlementName: Name
    def applicationIdentifier: String
    def getStackName: ZIO[Any, Nothing, Name] = ZIO.succeed(stackName)
    def getEntitlementName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(entitlementName)
    def getApplicationIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(applicationIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DisassociateApplicationFromEntitlementRequest
  ) extends zio.aws.appstream.model.DisassociateApplicationFromEntitlementRequest.ReadOnly {
    override val stackName: Name =
      zio.aws.appstream.model.primitives.Name(impl.stackName())
    override val entitlementName: Name =
      zio.aws.appstream.model.primitives.Name(impl.entitlementName())
    override val applicationIdentifier: String =
      impl.applicationIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DisassociateApplicationFromEntitlementRequest
  ): zio.aws.appstream.model.DisassociateApplicationFromEntitlementRequest.ReadOnly =
    new Wrapper(impl)
}
