package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  Timestamp,
  OrganizationalUnitDistinguishedName,
  DirectoryName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DirectoryConfig(
    directoryName: DirectoryName,
    organizationalUnitDistinguishedNames: Option[
      Iterable[OrganizationalUnitDistinguishedName]
    ] = None,
    serviceAccountCredentials: Option[
      zio.aws.appstream.model.ServiceAccountCredentials
    ] = None,
    createdTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DirectoryConfig = {
    import DirectoryConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DirectoryConfig
      .builder()
      .directoryName(DirectoryName.unwrap(directoryName): java.lang.String)
      .optionallyWith(
        organizationalUnitDistinguishedNames.map(value =>
          value.map { item =>
            OrganizationalUnitDistinguishedName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.organizationalUnitDistinguishedNames)
      .optionallyWith(
        serviceAccountCredentials.map(value => value.buildAwsValue())
      )(_.serviceAccountCredentials)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DirectoryConfig.ReadOnly =
    zio.aws.appstream.model.DirectoryConfig.wrap(buildAwsValue())
}
object DirectoryConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DirectoryConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DirectoryConfig =
      zio.aws.appstream.model.DirectoryConfig(
        directoryName,
        organizationalUnitDistinguishedNames.map(value => value),
        serviceAccountCredentials.map(value => value.asEditable),
        createdTime.map(value => value)
      )
    def directoryName: DirectoryName
    def organizationalUnitDistinguishedNames
        : Option[List[OrganizationalUnitDistinguishedName]]
    def serviceAccountCredentials
        : Option[zio.aws.appstream.model.ServiceAccountCredentials.ReadOnly]
    def createdTime: Option[Timestamp]
    def getDirectoryName: ZIO[Any, Nothing, DirectoryName] =
      ZIO.succeed(directoryName)
    def getOrganizationalUnitDistinguishedNames
        : ZIO[Any, AwsError, List[OrganizationalUnitDistinguishedName]] =
      AwsError.unwrapOptionField(
        "organizationalUnitDistinguishedNames",
        organizationalUnitDistinguishedNames
      )
    def getServiceAccountCredentials: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.ServiceAccountCredentials.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceAccountCredentials",
      serviceAccountCredentials
    )
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DirectoryConfig
  ) extends zio.aws.appstream.model.DirectoryConfig.ReadOnly {
    override val directoryName: DirectoryName =
      zio.aws.appstream.model.primitives.DirectoryName(impl.directoryName())
    override val organizationalUnitDistinguishedNames
        : Option[List[OrganizationalUnitDistinguishedName]] = scala
      .Option(impl.organizationalUnitDistinguishedNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.primitives
            .OrganizationalUnitDistinguishedName(item)
        }.toList
      )
    override val serviceAccountCredentials
        : Option[zio.aws.appstream.model.ServiceAccountCredentials.ReadOnly] =
      scala
        .Option(impl.serviceAccountCredentials())
        .map(value =>
          zio.aws.appstream.model.ServiceAccountCredentials.wrap(value)
        )
    override val createdTime: Option[Timestamp] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DirectoryConfig
  ): zio.aws.appstream.model.DirectoryConfig.ReadOnly = new Wrapper(impl)
}
