package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeUserStackAssociationsResponse(
    userStackAssociations: Option[
      Iterable[zio.aws.appstream.model.UserStackAssociation]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeUserStackAssociationsResponse = {
    import DescribeUserStackAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeUserStackAssociationsResponse
      .builder()
      .optionallyWith(
        userStackAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userStackAssociations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DescribeUserStackAssociationsResponse.ReadOnly =
    zio.aws.appstream.model.DescribeUserStackAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeUserStackAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeUserStackAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appstream.model.DescribeUserStackAssociationsResponse =
      zio.aws.appstream.model.DescribeUserStackAssociationsResponse(
        userStackAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def userStackAssociations
        : Option[List[zio.aws.appstream.model.UserStackAssociation.ReadOnly]]
    def nextToken: Option[String]
    def getUserStackAssociations: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.UserStackAssociation.ReadOnly
    ]] =
      AwsError.unwrapOptionField("userStackAssociations", userStackAssociations)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeUserStackAssociationsResponse
  ) extends zio.aws.appstream.model.DescribeUserStackAssociationsResponse.ReadOnly {
    override val userStackAssociations
        : Option[List[zio.aws.appstream.model.UserStackAssociation.ReadOnly]] =
      scala
        .Option(impl.userStackAssociations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.UserStackAssociation.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeUserStackAssociationsResponse
  ): zio.aws.appstream.model.DescribeUserStackAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
