package zio.aws.appstream.model
import java.lang.Integer
import zio.ZIO
import zio.aws.appstream.model.primitives.{MaxResults, Username}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeUserStackAssociationsRequest(
    stackName: Option[String] = None,
    userName: Option[Username] = None,
    authenticationType: Option[zio.aws.appstream.model.AuthenticationType] =
      None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeUserStackAssociationsRequest = {
    import DescribeUserStackAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeUserStackAssociationsRequest
      .builder()
      .optionallyWith(stackName.map(value => value: java.lang.String))(
        _.stackName
      )
      .optionallyWith(
        userName.map(value => Username.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DescribeUserStackAssociationsRequest.ReadOnly =
    zio.aws.appstream.model.DescribeUserStackAssociationsRequest
      .wrap(buildAwsValue())
}
object DescribeUserStackAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeUserStackAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appstream.model.DescribeUserStackAssociationsRequest =
      zio.aws.appstream.model.DescribeUserStackAssociationsRequest(
        stackName.map(value => value),
        userName.map(value => value),
        authenticationType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def stackName: Option[String]
    def userName: Option[Username]
    def authenticationType: Option[zio.aws.appstream.model.AuthenticationType]
    def maxResults: Option[MaxResults]
    def nextToken: Option[String]
    def getStackName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getUserName: ZIO[Any, AwsError, Username] =
      AwsError.unwrapOptionField("userName", userName)
    def getAuthenticationType
        : ZIO[Any, AwsError, zio.aws.appstream.model.AuthenticationType] =
      AwsError.unwrapOptionField("authenticationType", authenticationType)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeUserStackAssociationsRequest
  ) extends zio.aws.appstream.model.DescribeUserStackAssociationsRequest.ReadOnly {
    override val stackName: Option[String] =
      scala.Option(impl.stackName()).map(value => value: String)
    override val userName: Option[Username] = scala
      .Option(impl.userName())
      .map(value => zio.aws.appstream.model.primitives.Username(value))
    override val authenticationType
        : Option[zio.aws.appstream.model.AuthenticationType] = scala
      .Option(impl.authenticationType())
      .map(value => zio.aws.appstream.model.AuthenticationType.wrap(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.appstream.model.primitives.MaxResults(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeUserStackAssociationsRequest
  ): zio.aws.appstream.model.DescribeUserStackAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
