package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Name
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeImagePermissionsResponse(
    name: Option[Name] = None,
    sharedImagePermissionsList: Option[
      Iterable[zio.aws.appstream.model.SharedImagePermissions]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsResponse = {
    import DescribeImagePermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsResponse
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        sharedImagePermissionsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sharedImagePermissionsList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DescribeImagePermissionsResponse.ReadOnly =
    zio.aws.appstream.model.DescribeImagePermissionsResponse
      .wrap(buildAwsValue())
}
object DescribeImagePermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeImagePermissionsResponse =
      zio.aws.appstream.model.DescribeImagePermissionsResponse(
        name.map(value => value),
        sharedImagePermissionsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def name: Option[Name]
    def sharedImagePermissionsList
        : Option[List[zio.aws.appstream.model.SharedImagePermissions.ReadOnly]]
    def nextToken: Option[String]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getSharedImagePermissionsList: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.SharedImagePermissions.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "sharedImagePermissionsList",
      sharedImagePermissionsList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsResponse
  ) extends zio.aws.appstream.model.DescribeImagePermissionsResponse.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.appstream.model.primitives.Name(value))
    override val sharedImagePermissionsList: Option[
      List[zio.aws.appstream.model.SharedImagePermissions.ReadOnly]
    ] = scala
      .Option(impl.sharedImagePermissionsList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.SharedImagePermissions.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsResponse
  ): zio.aws.appstream.model.DescribeImagePermissionsResponse.ReadOnly =
    new Wrapper(impl)
}
