package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeImageBuildersResponse(
    imageBuilders: Option[Iterable[zio.aws.appstream.model.ImageBuilder]] =
      None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeImageBuildersResponse = {
    import DescribeImageBuildersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeImageBuildersResponse
      .builder()
      .optionallyWith(
        imageBuilders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.imageBuilders)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DescribeImageBuildersResponse.ReadOnly =
    zio.aws.appstream.model.DescribeImageBuildersResponse.wrap(buildAwsValue())
}
object DescribeImageBuildersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeImageBuildersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeImageBuildersResponse =
      zio.aws.appstream.model.DescribeImageBuildersResponse(
        imageBuilders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def imageBuilders
        : Option[List[zio.aws.appstream.model.ImageBuilder.ReadOnly]]
    def nextToken: Option[String]
    def getImageBuilders: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.ImageBuilder.ReadOnly
    ]] = AwsError.unwrapOptionField("imageBuilders", imageBuilders)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeImageBuildersResponse
  ) extends zio.aws.appstream.model.DescribeImageBuildersResponse.ReadOnly {
    override val imageBuilders
        : Option[List[zio.aws.appstream.model.ImageBuilder.ReadOnly]] = scala
      .Option(impl.imageBuilders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.ImageBuilder.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeImageBuildersResponse
  ): zio.aws.appstream.model.DescribeImageBuildersResponse.ReadOnly =
    new Wrapper(impl)
}
