package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeFleetsResponse(
    fleets: Option[Iterable[zio.aws.appstream.model.Fleet]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeFleetsResponse = {
    import DescribeFleetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeFleetsResponse
      .builder()
      .optionallyWith(
        fleets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fleets)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DescribeFleetsResponse.ReadOnly =
    zio.aws.appstream.model.DescribeFleetsResponse.wrap(buildAwsValue())
}
object DescribeFleetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeFleetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeFleetsResponse =
      zio.aws.appstream.model.DescribeFleetsResponse(
        fleets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def fleets: Option[List[zio.aws.appstream.model.Fleet.ReadOnly]]
    def nextToken: Option[String]
    def getFleets
        : ZIO[Any, AwsError, List[zio.aws.appstream.model.Fleet.ReadOnly]] =
      AwsError.unwrapOptionField("fleets", fleets)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeFleetsResponse
  ) extends zio.aws.appstream.model.DescribeFleetsResponse.ReadOnly {
    override val fleets: Option[List[zio.aws.appstream.model.Fleet.ReadOnly]] =
      scala
        .Option(impl.fleets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.Fleet.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeFleetsResponse
  ): zio.aws.appstream.model.DescribeFleetsResponse.ReadOnly = new Wrapper(impl)
}
