package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEntitlementsResponse(
    entitlements: Option[Iterable[zio.aws.appstream.model.Entitlement]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeEntitlementsResponse = {
    import DescribeEntitlementsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeEntitlementsResponse
      .builder()
      .optionallyWith(
        entitlements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entitlements)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DescribeEntitlementsResponse.ReadOnly =
    zio.aws.appstream.model.DescribeEntitlementsResponse.wrap(buildAwsValue())
}
object DescribeEntitlementsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeEntitlementsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeEntitlementsResponse =
      zio.aws.appstream.model.DescribeEntitlementsResponse(
        entitlements.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def entitlements: Option[List[zio.aws.appstream.model.Entitlement.ReadOnly]]
    def nextToken: Option[String]
    def getEntitlements: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.Entitlement.ReadOnly
    ]] = AwsError.unwrapOptionField("entitlements", entitlements)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeEntitlementsResponse
  ) extends zio.aws.appstream.model.DescribeEntitlementsResponse.ReadOnly {
    override val entitlements
        : Option[List[zio.aws.appstream.model.Entitlement.ReadOnly]] = scala
      .Option(impl.entitlements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.Entitlement.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeEntitlementsResponse
  ): zio.aws.appstream.model.DescribeEntitlementsResponse.ReadOnly =
    new Wrapper(impl)
}
