package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAppBlocksResponse(
    appBlocks: Option[Iterable[zio.aws.appstream.model.AppBlock]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeAppBlocksResponse = {
    import DescribeAppBlocksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeAppBlocksResponse
      .builder()
      .optionallyWith(
        appBlocks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appBlocks)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DescribeAppBlocksResponse.ReadOnly =
    zio.aws.appstream.model.DescribeAppBlocksResponse.wrap(buildAwsValue())
}
object DescribeAppBlocksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeAppBlocksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeAppBlocksResponse =
      zio.aws.appstream.model.DescribeAppBlocksResponse(
        appBlocks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def appBlocks: Option[List[zio.aws.appstream.model.AppBlock.ReadOnly]]
    def nextToken: Option[String]
    def getAppBlocks
        : ZIO[Any, AwsError, List[zio.aws.appstream.model.AppBlock.ReadOnly]] =
      AwsError.unwrapOptionField("appBlocks", appBlocks)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeAppBlocksResponse
  ) extends zio.aws.appstream.model.DescribeAppBlocksResponse.ReadOnly {
    override val appBlocks
        : Option[List[zio.aws.appstream.model.AppBlock.ReadOnly]] = scala
      .Option(impl.appBlocks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.AppBlock.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeAppBlocksResponse
  ): zio.aws.appstream.model.DescribeAppBlocksResponse.ReadOnly = new Wrapper(
    impl
  )
}
