package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{Integer, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAppBlocksRequest(
    arns: Option[Iterable[Arn]] = None,
    nextToken: Option[String] = None,
    maxResults: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeAppBlocksRequest = {
    import DescribeAppBlocksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeAppBlocksRequest
      .builder()
      .optionallyWith(
        arns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.arns)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DescribeAppBlocksRequest.ReadOnly =
    zio.aws.appstream.model.DescribeAppBlocksRequest.wrap(buildAwsValue())
}
object DescribeAppBlocksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeAppBlocksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeAppBlocksRequest =
      zio.aws.appstream.model.DescribeAppBlocksRequest(
        arns.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def arns: Option[List[Arn]]
    def nextToken: Option[String]
    def maxResults: Option[Integer]
    def getArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("arns", arns)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeAppBlocksRequest
  ) extends zio.aws.appstream.model.DescribeAppBlocksRequest.ReadOnly {
    override val arns: Option[List[Arn]] = scala
      .Option(impl.arns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.primitives.Arn(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeAppBlocksRequest
  ): zio.aws.appstream.model.DescribeAppBlocksRequest.ReadOnly = new Wrapper(
    impl
  )
}
