package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateUsageReportSubscriptionResponse(
    s3BucketName: Option[String] = None,
    schedule: Option[zio.aws.appstream.model.UsageReportSchedule] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateUsageReportSubscriptionResponse = {
    import CreateUsageReportSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateUsageReportSubscriptionResponse
      .builder()
      .optionallyWith(s3BucketName.map(value => value: java.lang.String))(
        _.s3BucketName
      )
      .optionallyWith(schedule.map(value => value.unwrap))(_.schedule)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.CreateUsageReportSubscriptionResponse.ReadOnly =
    zio.aws.appstream.model.CreateUsageReportSubscriptionResponse
      .wrap(buildAwsValue())
}
object CreateUsageReportSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateUsageReportSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appstream.model.CreateUsageReportSubscriptionResponse =
      zio.aws.appstream.model.CreateUsageReportSubscriptionResponse(
        s3BucketName.map(value => value),
        schedule.map(value => value)
      )
    def s3BucketName: Option[String]
    def schedule: Option[zio.aws.appstream.model.UsageReportSchedule]
    def getS3BucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.appstream.model.UsageReportSchedule] =
      AwsError.unwrapOptionField("schedule", schedule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateUsageReportSubscriptionResponse
  ) extends zio.aws.appstream.model.CreateUsageReportSubscriptionResponse.ReadOnly {
    override val s3BucketName: Option[String] =
      scala.Option(impl.s3BucketName()).map(value => value: String)
    override val schedule: Option[zio.aws.appstream.model.UsageReportSchedule] =
      scala
        .Option(impl.schedule())
        .map(value => zio.aws.appstream.model.UsageReportSchedule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateUsageReportSubscriptionResponse
  ): zio.aws.appstream.model.CreateUsageReportSubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
