package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateStreamingUrlResponse(
    streamingURL: Option[String] = None,
    expires: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateStreamingUrlResponse = {
    import CreateStreamingUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateStreamingUrlResponse
      .builder()
      .optionallyWith(streamingURL.map(value => value: java.lang.String))(
        _.streamingURL
      )
      .optionallyWith(expires.map(value => Timestamp.unwrap(value): Instant))(
        _.expires
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateStreamingUrlResponse.ReadOnly =
    zio.aws.appstream.model.CreateStreamingUrlResponse.wrap(buildAwsValue())
}
object CreateStreamingUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateStreamingUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateStreamingUrlResponse =
      zio.aws.appstream.model.CreateStreamingUrlResponse(
        streamingURL.map(value => value),
        expires.map(value => value)
      )
    def streamingURL: Option[String]
    def expires: Option[Timestamp]
    def getStreamingURL: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("streamingURL", streamingURL)
    def getExpires: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expires", expires)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateStreamingUrlResponse
  ) extends zio.aws.appstream.model.CreateStreamingUrlResponse.ReadOnly {
    override val streamingURL: Option[String] =
      scala.Option(impl.streamingURL()).map(value => value: String)
    override val expires: Option[Timestamp] = scala
      .Option(impl.expires())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateStreamingUrlResponse
  ): zio.aws.appstream.model.CreateStreamingUrlResponse.ReadOnly = new Wrapper(
    impl
  )
}
