package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateImageBuilderResponse(
    imageBuilder: Option[zio.aws.appstream.model.ImageBuilder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateImageBuilderResponse = {
    import CreateImageBuilderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateImageBuilderResponse
      .builder()
      .optionallyWith(imageBuilder.map(value => value.buildAwsValue()))(
        _.imageBuilder
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateImageBuilderResponse.ReadOnly =
    zio.aws.appstream.model.CreateImageBuilderResponse.wrap(buildAwsValue())
}
object CreateImageBuilderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateImageBuilderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateImageBuilderResponse =
      zio.aws.appstream.model
        .CreateImageBuilderResponse(imageBuilder.map(value => value.asEditable))
    def imageBuilder: Option[zio.aws.appstream.model.ImageBuilder.ReadOnly]
    def getImageBuilder
        : ZIO[Any, AwsError, zio.aws.appstream.model.ImageBuilder.ReadOnly] =
      AwsError.unwrapOptionField("imageBuilder", imageBuilder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateImageBuilderResponse
  ) extends zio.aws.appstream.model.CreateImageBuilderResponse.ReadOnly {
    override val imageBuilder
        : Option[zio.aws.appstream.model.ImageBuilder.ReadOnly] = scala
      .Option(impl.imageBuilder())
      .map(value => zio.aws.appstream.model.ImageBuilder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateImageBuilderResponse
  ): zio.aws.appstream.model.CreateImageBuilderResponse.ReadOnly = new Wrapper(
    impl
  )
}
