package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFleetResponse(
    fleet: Option[zio.aws.appstream.model.Fleet] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateFleetResponse = {
    import CreateFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateFleetResponse
      .builder()
      .optionallyWith(fleet.map(value => value.buildAwsValue()))(_.fleet)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateFleetResponse.ReadOnly =
    zio.aws.appstream.model.CreateFleetResponse.wrap(buildAwsValue())
}
object CreateFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateFleetResponse =
      zio.aws.appstream.model
        .CreateFleetResponse(fleet.map(value => value.asEditable))
    def fleet: Option[zio.aws.appstream.model.Fleet.ReadOnly]
    def getFleet: ZIO[Any, AwsError, zio.aws.appstream.model.Fleet.ReadOnly] =
      AwsError.unwrapOptionField("fleet", fleet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateFleetResponse
  ) extends zio.aws.appstream.model.CreateFleetResponse.ReadOnly {
    override val fleet: Option[zio.aws.appstream.model.Fleet.ReadOnly] = scala
      .Option(impl.fleet())
      .map(value => zio.aws.appstream.model.Fleet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateFleetResponse
  ): zio.aws.appstream.model.CreateFleetResponse.ReadOnly = new Wrapper(impl)
}
