package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  DisplayName,
  BooleanObject,
  TagValue,
  Arn,
  Integer,
  Description,
  UsbDeviceFilterString,
  Name,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFleetRequest(
    name: Name,
    imageName: Option[String] = None,
    imageArn: Option[Arn] = None,
    instanceType: String,
    fleetType: Option[zio.aws.appstream.model.FleetType] = None,
    computeCapacity: Option[zio.aws.appstream.model.ComputeCapacity] = None,
    vpcConfig: Option[zio.aws.appstream.model.VpcConfig] = None,
    maxUserDurationInSeconds: Option[Integer] = None,
    disconnectTimeoutInSeconds: Option[Integer] = None,
    description: Option[Description] = None,
    displayName: Option[DisplayName] = None,
    enableDefaultInternetAccess: Option[BooleanObject] = None,
    domainJoinInfo: Option[zio.aws.appstream.model.DomainJoinInfo] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    idleDisconnectTimeoutInSeconds: Option[Integer] = None,
    iamRoleArn: Option[Arn] = None,
    streamView: Option[zio.aws.appstream.model.StreamView] = None,
    platform: Option[zio.aws.appstream.model.PlatformType] = None,
    maxConcurrentSessions: Option[Integer] = None,
    usbDeviceFilterStrings: Option[Iterable[UsbDeviceFilterString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateFleetRequest = {
    import CreateFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateFleetRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(imageName.map(value => value: java.lang.String))(
        _.imageName
      )
      .optionallyWith(
        imageArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.imageArn)
      .instanceType(instanceType: java.lang.String)
      .optionallyWith(fleetType.map(value => value.unwrap))(_.fleetType)
      .optionallyWith(computeCapacity.map(value => value.buildAwsValue()))(
        _.computeCapacity
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        maxUserDurationInSeconds.map(value => value: java.lang.Integer)
      )(_.maxUserDurationInSeconds)
      .optionallyWith(
        disconnectTimeoutInSeconds.map(value => value: java.lang.Integer)
      )(_.disconnectTimeoutInSeconds)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        enableDefaultInternetAccess.map(value => value: java.lang.Boolean)
      )(_.enableDefaultInternetAccess)
      .optionallyWith(domainJoinInfo.map(value => value.buildAwsValue()))(
        _.domainJoinInfo
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        idleDisconnectTimeoutInSeconds.map(value => value: java.lang.Integer)
      )(_.idleDisconnectTimeoutInSeconds)
      .optionallyWith(
        iamRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(streamView.map(value => value.unwrap))(_.streamView)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        maxConcurrentSessions.map(value => value: java.lang.Integer)
      )(_.maxConcurrentSessions)
      .optionallyWith(
        usbDeviceFilterStrings.map(value =>
          value.map { item =>
            UsbDeviceFilterString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.usbDeviceFilterStrings)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateFleetRequest.ReadOnly =
    zio.aws.appstream.model.CreateFleetRequest.wrap(buildAwsValue())
}
object CreateFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateFleetRequest =
      zio.aws.appstream.model.CreateFleetRequest(
        name,
        imageName.map(value => value),
        imageArn.map(value => value),
        instanceType,
        fleetType.map(value => value),
        computeCapacity.map(value => value.asEditable),
        vpcConfig.map(value => value.asEditable),
        maxUserDurationInSeconds.map(value => value),
        disconnectTimeoutInSeconds.map(value => value),
        description.map(value => value),
        displayName.map(value => value),
        enableDefaultInternetAccess.map(value => value),
        domainJoinInfo.map(value => value.asEditable),
        tags.map(value => value),
        idleDisconnectTimeoutInSeconds.map(value => value),
        iamRoleArn.map(value => value),
        streamView.map(value => value),
        platform.map(value => value),
        maxConcurrentSessions.map(value => value),
        usbDeviceFilterStrings.map(value => value)
      )
    def name: Name
    def imageName: Option[String]
    def imageArn: Option[Arn]
    def instanceType: String
    def fleetType: Option[zio.aws.appstream.model.FleetType]
    def computeCapacity
        : Option[zio.aws.appstream.model.ComputeCapacity.ReadOnly]
    def vpcConfig: Option[zio.aws.appstream.model.VpcConfig.ReadOnly]
    def maxUserDurationInSeconds: Option[Integer]
    def disconnectTimeoutInSeconds: Option[Integer]
    def description: Option[Description]
    def displayName: Option[DisplayName]
    def enableDefaultInternetAccess: Option[BooleanObject]
    def domainJoinInfo: Option[zio.aws.appstream.model.DomainJoinInfo.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def idleDisconnectTimeoutInSeconds: Option[Integer]
    def iamRoleArn: Option[Arn]
    def streamView: Option[zio.aws.appstream.model.StreamView]
    def platform: Option[zio.aws.appstream.model.PlatformType]
    def maxConcurrentSessions: Option[Integer]
    def usbDeviceFilterStrings: Option[List[UsbDeviceFilterString]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getImageName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageName", imageName)
    def getImageArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("imageArn", imageArn)
    def getInstanceType: ZIO[Any, Nothing, String] = ZIO.succeed(instanceType)
    def getFleetType: ZIO[Any, AwsError, zio.aws.appstream.model.FleetType] =
      AwsError.unwrapOptionField("fleetType", fleetType)
    def getComputeCapacity
        : ZIO[Any, AwsError, zio.aws.appstream.model.ComputeCapacity.ReadOnly] =
      AwsError.unwrapOptionField("computeCapacity", computeCapacity)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.appstream.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getMaxUserDurationInSeconds: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maxUserDurationInSeconds", maxUserDurationInSeconds)
    def getDisconnectTimeoutInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "disconnectTimeoutInSeconds",
        disconnectTimeoutInSeconds
      )
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getEnableDefaultInternetAccess: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "enableDefaultInternetAccess",
        enableDefaultInternetAccess
      )
    def getDomainJoinInfo
        : ZIO[Any, AwsError, zio.aws.appstream.model.DomainJoinInfo.ReadOnly] =
      AwsError.unwrapOptionField("domainJoinInfo", domainJoinInfo)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getIdleDisconnectTimeoutInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "idleDisconnectTimeoutInSeconds",
        idleDisconnectTimeoutInSeconds
      )
    def getIamRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getStreamView: ZIO[Any, AwsError, zio.aws.appstream.model.StreamView] =
      AwsError.unwrapOptionField("streamView", streamView)
    def getPlatform: ZIO[Any, AwsError, zio.aws.appstream.model.PlatformType] =
      AwsError.unwrapOptionField("platform", platform)
    def getMaxConcurrentSessions: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxConcurrentSessions", maxConcurrentSessions)
    def getUsbDeviceFilterStrings
        : ZIO[Any, AwsError, List[UsbDeviceFilterString]] = AwsError
      .unwrapOptionField("usbDeviceFilterStrings", usbDeviceFilterStrings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateFleetRequest
  ) extends zio.aws.appstream.model.CreateFleetRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
    override val imageName: Option[String] =
      scala.Option(impl.imageName()).map(value => value: String)
    override val imageArn: Option[Arn] = scala
      .Option(impl.imageArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val instanceType: String = impl.instanceType(): String
    override val fleetType: Option[zio.aws.appstream.model.FleetType] = scala
      .Option(impl.fleetType())
      .map(value => zio.aws.appstream.model.FleetType.wrap(value))
    override val computeCapacity
        : Option[zio.aws.appstream.model.ComputeCapacity.ReadOnly] = scala
      .Option(impl.computeCapacity())
      .map(value => zio.aws.appstream.model.ComputeCapacity.wrap(value))
    override val vpcConfig: Option[zio.aws.appstream.model.VpcConfig.ReadOnly] =
      scala
        .Option(impl.vpcConfig())
        .map(value => zio.aws.appstream.model.VpcConfig.wrap(value))
    override val maxUserDurationInSeconds: Option[Integer] =
      scala.Option(impl.maxUserDurationInSeconds()).map(value => value: Integer)
    override val disconnectTimeoutInSeconds: Option[Integer] = scala
      .Option(impl.disconnectTimeoutInSeconds())
      .map(value => value: Integer)
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appstream.model.primitives.Description(value))
    override val displayName: Option[DisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.appstream.model.primitives.DisplayName(value))
    override val enableDefaultInternetAccess: Option[BooleanObject] = scala
      .Option(impl.enableDefaultInternetAccess())
      .map(value => value: BooleanObject)
    override val domainJoinInfo
        : Option[zio.aws.appstream.model.DomainJoinInfo.ReadOnly] = scala
      .Option(impl.domainJoinInfo())
      .map(value => zio.aws.appstream.model.DomainJoinInfo.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appstream.model.primitives
              .TagKey(key) -> zio.aws.appstream.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val idleDisconnectTimeoutInSeconds: Option[Integer] = scala
      .Option(impl.idleDisconnectTimeoutInSeconds())
      .map(value => value: Integer)
    override val iamRoleArn: Option[Arn] = scala
      .Option(impl.iamRoleArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val streamView: Option[zio.aws.appstream.model.StreamView] = scala
      .Option(impl.streamView())
      .map(value => zio.aws.appstream.model.StreamView.wrap(value))
    override val platform: Option[zio.aws.appstream.model.PlatformType] = scala
      .Option(impl.platform())
      .map(value => zio.aws.appstream.model.PlatformType.wrap(value))
    override val maxConcurrentSessions: Option[Integer] =
      scala.Option(impl.maxConcurrentSessions()).map(value => value: Integer)
    override val usbDeviceFilterStrings: Option[List[UsbDeviceFilterString]] =
      scala
        .Option(impl.usbDeviceFilterStrings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.primitives.UsbDeviceFilterString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateFleetRequest
  ): zio.aws.appstream.model.CreateFleetRequest.ReadOnly = new Wrapper(impl)
}
