package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{Description, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateEntitlementRequest(
    name: Name,
    stackName: Name,
    description: Option[Description] = None,
    appVisibility: zio.aws.appstream.model.AppVisibility,
    attributes: Iterable[zio.aws.appstream.model.EntitlementAttribute]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateEntitlementRequest = {
    import CreateEntitlementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateEntitlementRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .stackName(Name.unwrap(stackName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .appVisibility(appVisibility.unwrap)
      .attributes(attributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateEntitlementRequest.ReadOnly =
    zio.aws.appstream.model.CreateEntitlementRequest.wrap(buildAwsValue())
}
object CreateEntitlementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateEntitlementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateEntitlementRequest =
      zio.aws.appstream.model.CreateEntitlementRequest(
        name,
        stackName,
        description.map(value => value),
        appVisibility,
        attributes.map { item =>
          item.asEditable
        }
      )
    def name: Name
    def stackName: Name
    def description: Option[Description]
    def appVisibility: zio.aws.appstream.model.AppVisibility
    def attributes: List[zio.aws.appstream.model.EntitlementAttribute.ReadOnly]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getStackName: ZIO[Any, Nothing, Name] = ZIO.succeed(stackName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getAppVisibility
        : ZIO[Any, Nothing, zio.aws.appstream.model.AppVisibility] =
      ZIO.succeed(appVisibility)
    def getAttributes: ZIO[Any, Nothing, List[
      zio.aws.appstream.model.EntitlementAttribute.ReadOnly
    ]] = ZIO.succeed(attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateEntitlementRequest
  ) extends zio.aws.appstream.model.CreateEntitlementRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
    override val stackName: Name =
      zio.aws.appstream.model.primitives.Name(impl.stackName())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appstream.model.primitives.Description(value))
    override val appVisibility: zio.aws.appstream.model.AppVisibility =
      zio.aws.appstream.model.AppVisibility.wrap(impl.appVisibility())
    override val attributes
        : List[zio.aws.appstream.model.EntitlementAttribute.ReadOnly] = impl
      .attributes()
      .asScala
      .map { item =>
        zio.aws.appstream.model.EntitlementAttribute.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateEntitlementRequest
  ): zio.aws.appstream.model.CreateEntitlementRequest.ReadOnly = new Wrapper(
    impl
  )
}
