package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  OrganizationalUnitDistinguishedName,
  DirectoryName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDirectoryConfigRequest(
    directoryName: DirectoryName,
    organizationalUnitDistinguishedNames: Iterable[
      OrganizationalUnitDistinguishedName
    ],
    serviceAccountCredentials: Option[
      zio.aws.appstream.model.ServiceAccountCredentials
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateDirectoryConfigRequest = {
    import CreateDirectoryConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateDirectoryConfigRequest
      .builder()
      .directoryName(DirectoryName.unwrap(directoryName): java.lang.String)
      .organizationalUnitDistinguishedNames(
        organizationalUnitDistinguishedNames.map { item =>
          OrganizationalUnitDistinguishedName.unwrap(item): java.lang.String
        }.asJavaCollection
      )
      .optionallyWith(
        serviceAccountCredentials.map(value => value.buildAwsValue())
      )(_.serviceAccountCredentials)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.CreateDirectoryConfigRequest.ReadOnly =
    zio.aws.appstream.model.CreateDirectoryConfigRequest.wrap(buildAwsValue())
}
object CreateDirectoryConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateDirectoryConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateDirectoryConfigRequest =
      zio.aws.appstream.model.CreateDirectoryConfigRequest(
        directoryName,
        organizationalUnitDistinguishedNames,
        serviceAccountCredentials.map(value => value.asEditable)
      )
    def directoryName: DirectoryName
    def organizationalUnitDistinguishedNames
        : List[OrganizationalUnitDistinguishedName]
    def serviceAccountCredentials
        : Option[zio.aws.appstream.model.ServiceAccountCredentials.ReadOnly]
    def getDirectoryName: ZIO[Any, Nothing, DirectoryName] =
      ZIO.succeed(directoryName)
    def getOrganizationalUnitDistinguishedNames
        : ZIO[Any, Nothing, List[OrganizationalUnitDistinguishedName]] =
      ZIO.succeed(organizationalUnitDistinguishedNames)
    def getServiceAccountCredentials: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.ServiceAccountCredentials.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceAccountCredentials",
      serviceAccountCredentials
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateDirectoryConfigRequest
  ) extends zio.aws.appstream.model.CreateDirectoryConfigRequest.ReadOnly {
    override val directoryName: DirectoryName =
      zio.aws.appstream.model.primitives.DirectoryName(impl.directoryName())
    override val organizationalUnitDistinguishedNames
        : List[OrganizationalUnitDistinguishedName] = impl
      .organizationalUnitDistinguishedNames()
      .asScala
      .map { item =>
        zio.aws.appstream.model.primitives
          .OrganizationalUnitDistinguishedName(item)
      }
      .toList
    override val serviceAccountCredentials
        : Option[zio.aws.appstream.model.ServiceAccountCredentials.ReadOnly] =
      scala
        .Option(impl.serviceAccountCredentials())
        .map(value =>
          zio.aws.appstream.model.ServiceAccountCredentials.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateDirectoryConfigRequest
  ): zio.aws.appstream.model.CreateDirectoryConfigRequest.ReadOnly =
    new Wrapper(impl)
}
