package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  DisplayName,
  TagValue,
  Description,
  Name,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateAppBlockRequest(
    name: Name,
    description: Option[Description] = None,
    displayName: Option[DisplayName] = None,
    sourceS3Location: zio.aws.appstream.model.S3Location,
    setupScriptDetails: zio.aws.appstream.model.ScriptDetails,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateAppBlockRequest = {
    import CreateAppBlockRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateAppBlockRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .sourceS3Location(sourceS3Location.buildAwsValue())
      .setupScriptDetails(setupScriptDetails.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateAppBlockRequest.ReadOnly =
    zio.aws.appstream.model.CreateAppBlockRequest.wrap(buildAwsValue())
}
object CreateAppBlockRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateAppBlockRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateAppBlockRequest =
      zio.aws.appstream.model.CreateAppBlockRequest(
        name,
        description.map(value => value),
        displayName.map(value => value),
        sourceS3Location.asEditable,
        setupScriptDetails.asEditable,
        tags.map(value => value)
      )
    def name: Name
    def description: Option[Description]
    def displayName: Option[DisplayName]
    def sourceS3Location: zio.aws.appstream.model.S3Location.ReadOnly
    def setupScriptDetails: zio.aws.appstream.model.ScriptDetails.ReadOnly
    def tags: Option[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getSourceS3Location
        : ZIO[Any, Nothing, zio.aws.appstream.model.S3Location.ReadOnly] =
      ZIO.succeed(sourceS3Location)
    def getSetupScriptDetails
        : ZIO[Any, Nothing, zio.aws.appstream.model.ScriptDetails.ReadOnly] =
      ZIO.succeed(setupScriptDetails)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateAppBlockRequest
  ) extends zio.aws.appstream.model.CreateAppBlockRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appstream.model.primitives.Description(value))
    override val displayName: Option[DisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.appstream.model.primitives.DisplayName(value))
    override val sourceS3Location: zio.aws.appstream.model.S3Location.ReadOnly =
      zio.aws.appstream.model.S3Location.wrap(impl.sourceS3Location())
    override val setupScriptDetails
        : zio.aws.appstream.model.ScriptDetails.ReadOnly =
      zio.aws.appstream.model.ScriptDetails.wrap(impl.setupScriptDetails())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appstream.model.primitives
              .TagKey(key) -> zio.aws.appstream.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateAppBlockRequest
  ): zio.aws.appstream.model.CreateAppBlockRequest.ReadOnly = new Wrapper(impl)
}
