package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.SettingsGroup
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ApplicationSettings(
    enabled: Boolean,
    settingsGroup: Option[SettingsGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ApplicationSettings = {
    import ApplicationSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ApplicationSettings
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(
        settingsGroup.map(value =>
          SettingsGroup.unwrap(value): java.lang.String
        )
      )(_.settingsGroup)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.ApplicationSettings.ReadOnly =
    zio.aws.appstream.model.ApplicationSettings.wrap(buildAwsValue())
}
object ApplicationSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ApplicationSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ApplicationSettings =
      zio.aws.appstream.model
        .ApplicationSettings(enabled, settingsGroup.map(value => value))
    def enabled: Boolean
    def settingsGroup: Option[SettingsGroup]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getSettingsGroup: ZIO[Any, AwsError, SettingsGroup] =
      AwsError.unwrapOptionField("settingsGroup", settingsGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ApplicationSettings
  ) extends zio.aws.appstream.model.ApplicationSettings.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val settingsGroup: Option[SettingsGroup] = scala
      .Option(impl.settingsGroup())
      .map(value => zio.aws.appstream.model.primitives.SettingsGroup(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ApplicationSettings
  ): zio.aws.appstream.model.ApplicationSettings.ReadOnly = new Wrapper(impl)
}
