package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait Action {
  def unwrap: software.amazon.awssdk.services.appstream.model.Action
}
object Action {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.Action
  ): zio.aws.appstream.model.Action = value match {
    case software.amazon.awssdk.services.appstream.model.Action.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.Action.CLIPBOARD_COPY_FROM_LOCAL_DEVICE =>
      val r = CLIPBOARD_COPY_FROM_LOCAL_DEVICE
      r
    case software.amazon.awssdk.services.appstream.model.Action.CLIPBOARD_COPY_TO_LOCAL_DEVICE =>
      val r = CLIPBOARD_COPY_TO_LOCAL_DEVICE
      r
    case software.amazon.awssdk.services.appstream.model.Action.FILE_UPLOAD =>
      val r = FILE_UPLOAD
      r
    case software.amazon.awssdk.services.appstream.model.Action.FILE_DOWNLOAD =>
      val r = FILE_DOWNLOAD
      r
    case software.amazon.awssdk.services.appstream.model.Action.PRINTING_TO_LOCAL_DEVICE =>
      val r = PRINTING_TO_LOCAL_DEVICE
      r
    case software.amazon.awssdk.services.appstream.model.Action.DOMAIN_PASSWORD_SIGNIN =>
      val r = DOMAIN_PASSWORD_SIGNIN
      r
    case software.amazon.awssdk.services.appstream.model.Action.DOMAIN_SMART_CARD_SIGNIN =>
      val r = DOMAIN_SMART_CARD_SIGNIN
      r
  }
  case object unknownToSdkVersion extends zio.aws.appstream.model.Action {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.Action =
      software.amazon.awssdk.services.appstream.model.Action.UNKNOWN_TO_SDK_VERSION
  }
  case object CLIPBOARD_COPY_FROM_LOCAL_DEVICE
      extends zio.aws.appstream.model.Action {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.Action =
      software.amazon.awssdk.services.appstream.model.Action.CLIPBOARD_COPY_FROM_LOCAL_DEVICE
  }
  case object CLIPBOARD_COPY_TO_LOCAL_DEVICE
      extends zio.aws.appstream.model.Action {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.Action =
      software.amazon.awssdk.services.appstream.model.Action.CLIPBOARD_COPY_TO_LOCAL_DEVICE
  }
  case object FILE_UPLOAD extends zio.aws.appstream.model.Action {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.Action =
      software.amazon.awssdk.services.appstream.model.Action.FILE_UPLOAD
  }
  case object FILE_DOWNLOAD extends zio.aws.appstream.model.Action {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.Action =
      software.amazon.awssdk.services.appstream.model.Action.FILE_DOWNLOAD
  }
  case object PRINTING_TO_LOCAL_DEVICE extends zio.aws.appstream.model.Action {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.Action =
      software.amazon.awssdk.services.appstream.model.Action.PRINTING_TO_LOCAL_DEVICE
  }
  case object DOMAIN_PASSWORD_SIGNIN extends zio.aws.appstream.model.Action {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.Action =
      software.amazon.awssdk.services.appstream.model.Action.DOMAIN_PASSWORD_SIGNIN
  }
  case object DOMAIN_SMART_CARD_SIGNIN extends zio.aws.appstream.model.Action {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.Action =
      software.amazon.awssdk.services.appstream.model.Action.DOMAIN_SMART_CARD_SIGNIN
  }
}
