package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateStackResponse(
    stack: Option[zio.aws.appstream.model.Stack] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UpdateStackResponse = {
    import UpdateStackResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UpdateStackResponse
      .builder()
      .optionallyWith(stack.map(value => value.buildAwsValue()))(_.stack)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.UpdateStackResponse.ReadOnly =
    zio.aws.appstream.model.UpdateStackResponse.wrap(buildAwsValue())
}
object UpdateStackResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UpdateStackResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UpdateStackResponse =
      zio.aws.appstream.model
        .UpdateStackResponse(stack.map(value => value.asEditable))
    def stack: Option[zio.aws.appstream.model.Stack.ReadOnly]
    def getStack: ZIO[Any, AwsError, zio.aws.appstream.model.Stack.ReadOnly] =
      AwsError.unwrapOptionField("stack", stack)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UpdateStackResponse
  ) extends zio.aws.appstream.model.UpdateStackResponse.ReadOnly {
    override val stack: Option[zio.aws.appstream.model.Stack.ReadOnly] = scala
      .Option(impl.stack())
      .map(value => zio.aws.appstream.model.Stack.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UpdateStackResponse
  ): zio.aws.appstream.model.UpdateStackResponse.ReadOnly = new Wrapper(impl)
}
