package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait SessionConnectionState {
  def unwrap
      : software.amazon.awssdk.services.appstream.model.SessionConnectionState
}
object SessionConnectionState {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.SessionConnectionState
  ): zio.aws.appstream.model.SessionConnectionState = value match {
    case software.amazon.awssdk.services.appstream.model.SessionConnectionState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.SessionConnectionState.CONNECTED =>
      val r = CONNECTED
      r
    case software.amazon.awssdk.services.appstream.model.SessionConnectionState.NOT_CONNECTED =>
      val r = NOT_CONNECTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.SessionConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.SessionConnectionState =
      software.amazon.awssdk.services.appstream.model.SessionConnectionState.UNKNOWN_TO_SDK_VERSION
  }
  case object CONNECTED extends zio.aws.appstream.model.SessionConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.SessionConnectionState =
      software.amazon.awssdk.services.appstream.model.SessionConnectionState.CONNECTED
  }
  case object NOT_CONNECTED
      extends zio.aws.appstream.model.SessionConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.SessionConnectionState =
      software.amazon.awssdk.services.appstream.model.SessionConnectionState.NOT_CONNECTED
  }
}
