package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeImagesResponse(
    images: Option[Iterable[zio.aws.appstream.model.Image]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeImagesResponse = {
    import DescribeImagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeImagesResponse
      .builder()
      .optionallyWith(
        images.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.images)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DescribeImagesResponse.ReadOnly =
    zio.aws.appstream.model.DescribeImagesResponse.wrap(buildAwsValue())
}
object DescribeImagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeImagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeImagesResponse =
      zio.aws.appstream.model.DescribeImagesResponse(
        images.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def images: Option[List[zio.aws.appstream.model.Image.ReadOnly]]
    def nextToken: Option[String]
    def getImages
        : ZIO[Any, AwsError, List[zio.aws.appstream.model.Image.ReadOnly]] =
      AwsError.unwrapOptionField("images", images)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeImagesResponse
  ) extends zio.aws.appstream.model.DescribeImagesResponse.ReadOnly {
    override val images: Option[List[zio.aws.appstream.model.Image.ReadOnly]] =
      scala
        .Option(impl.images())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.Image.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeImagesResponse
  ): zio.aws.appstream.model.DescribeImagesResponse.ReadOnly = new Wrapper(impl)
}
