package zio.aws.appstream.model
import java.lang.Integer
import zio.ZIO
import zio.aws.appstream.model.primitives.{AwsAccountId, MaxResults, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeImagePermissionsRequest(
    name: Name,
    maxResults: Option[MaxResults] = None,
    sharedAwsAccountIds: Option[Iterable[AwsAccountId]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsRequest = {
    import DescribeImagePermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        sharedAwsAccountIds.map(value =>
          value.map { item =>
            AwsAccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sharedAwsAccountIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DescribeImagePermissionsRequest.ReadOnly =
    zio.aws.appstream.model.DescribeImagePermissionsRequest
      .wrap(buildAwsValue())
}
object DescribeImagePermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeImagePermissionsRequest =
      zio.aws.appstream.model.DescribeImagePermissionsRequest(
        name,
        maxResults.map(value => value),
        sharedAwsAccountIds.map(value => value),
        nextToken.map(value => value)
      )
    def name: Name
    def maxResults: Option[MaxResults]
    def sharedAwsAccountIds: Option[List[AwsAccountId]]
    def nextToken: Option[String]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSharedAwsAccountIds: ZIO[Any, AwsError, List[AwsAccountId]] =
      AwsError.unwrapOptionField("sharedAwsAccountIds", sharedAwsAccountIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsRequest
  ) extends zio.aws.appstream.model.DescribeImagePermissionsRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.appstream.model.primitives.MaxResults(value))
    override val sharedAwsAccountIds: Option[List[AwsAccountId]] = scala
      .Option(impl.sharedAwsAccountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.primitives.AwsAccountId(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsRequest
  ): zio.aws.appstream.model.DescribeImagePermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
