package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeApplicationFleetAssociationsResponse(
    applicationFleetAssociations: Option[
      Iterable[zio.aws.appstream.model.ApplicationFleetAssociation]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsResponse = {
    import DescribeApplicationFleetAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsResponse
      .builder()
      .optionallyWith(
        applicationFleetAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applicationFleetAssociations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DescribeApplicationFleetAssociationsResponse.ReadOnly =
    zio.aws.appstream.model.DescribeApplicationFleetAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeApplicationFleetAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appstream.model.DescribeApplicationFleetAssociationsResponse =
      zio.aws.appstream.model.DescribeApplicationFleetAssociationsResponse(
        applicationFleetAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def applicationFleetAssociations: Option[
      List[zio.aws.appstream.model.ApplicationFleetAssociation.ReadOnly]
    ]
    def nextToken: Option[String]
    def getApplicationFleetAssociations: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.ApplicationFleetAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "applicationFleetAssociations",
      applicationFleetAssociations
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsResponse
  ) extends zio.aws.appstream.model.DescribeApplicationFleetAssociationsResponse.ReadOnly {
    override val applicationFleetAssociations: Option[
      List[zio.aws.appstream.model.ApplicationFleetAssociation.ReadOnly]
    ] = scala
      .Option(impl.applicationFleetAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.ApplicationFleetAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsResponse
  ): zio.aws.appstream.model.DescribeApplicationFleetAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
