package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateUpdatedImageResponse(
    image: Option[zio.aws.appstream.model.Image] = None,
    canUpdateImage: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateUpdatedImageResponse = {
    import CreateUpdatedImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateUpdatedImageResponse
      .builder()
      .optionallyWith(image.map(value => value.buildAwsValue()))(_.image)
      .optionallyWith(canUpdateImage.map(value => value: java.lang.Boolean))(
        _.canUpdateImage
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateUpdatedImageResponse.ReadOnly =
    zio.aws.appstream.model.CreateUpdatedImageResponse.wrap(buildAwsValue())
}
object CreateUpdatedImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateUpdatedImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateUpdatedImageResponse =
      zio.aws.appstream.model.CreateUpdatedImageResponse(
        image.map(value => value.asEditable),
        canUpdateImage.map(value => value)
      )
    def image: Option[zio.aws.appstream.model.Image.ReadOnly]
    def canUpdateImage: Option[Boolean]
    def getImage: ZIO[Any, AwsError, zio.aws.appstream.model.Image.ReadOnly] =
      AwsError.unwrapOptionField("image", image)
    def getCanUpdateImage: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("canUpdateImage", canUpdateImage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateUpdatedImageResponse
  ) extends zio.aws.appstream.model.CreateUpdatedImageResponse.ReadOnly {
    override val image: Option[zio.aws.appstream.model.Image.ReadOnly] = scala
      .Option(impl.image())
      .map(value => zio.aws.appstream.model.Image.wrap(value))
    override val canUpdateImage: Option[Boolean] =
      scala.Option(impl.canUpdateImage()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateUpdatedImageResponse
  ): zio.aws.appstream.model.CreateUpdatedImageResponse.ReadOnly = new Wrapper(
    impl
  )
}
