package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.StreamingUrlUserId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateStreamingUrlRequest(
    stackName: String,
    fleetName: String,
    userId: StreamingUrlUserId,
    applicationId: Option[String] = None,
    validity: Option[Long] = None,
    sessionContext: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateStreamingUrlRequest = {
    import CreateStreamingUrlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateStreamingUrlRequest
      .builder()
      .stackName(stackName: java.lang.String)
      .fleetName(fleetName: java.lang.String)
      .userId(StreamingUrlUserId.unwrap(userId): java.lang.String)
      .optionallyWith(applicationId.map(value => value: java.lang.String))(
        _.applicationId
      )
      .optionallyWith(validity.map(value => value: java.lang.Long))(_.validity)
      .optionallyWith(sessionContext.map(value => value: java.lang.String))(
        _.sessionContext
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateStreamingUrlRequest.ReadOnly =
    zio.aws.appstream.model.CreateStreamingUrlRequest.wrap(buildAwsValue())
}
object CreateStreamingUrlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateStreamingUrlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateStreamingUrlRequest =
      zio.aws.appstream.model.CreateStreamingUrlRequest(
        stackName,
        fleetName,
        userId,
        applicationId.map(value => value),
        validity.map(value => value),
        sessionContext.map(value => value)
      )
    def stackName: String
    def fleetName: String
    def userId: StreamingUrlUserId
    def applicationId: Option[String]
    def validity: Option[Long]
    def sessionContext: Option[String]
    def getStackName: ZIO[Any, Nothing, String] = ZIO.succeed(stackName)
    def getFleetName: ZIO[Any, Nothing, String] = ZIO.succeed(fleetName)
    def getUserId: ZIO[Any, Nothing, StreamingUrlUserId] = ZIO.succeed(userId)
    def getApplicationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getValidity: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("validity", validity)
    def getSessionContext: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionContext", sessionContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateStreamingUrlRequest
  ) extends zio.aws.appstream.model.CreateStreamingUrlRequest.ReadOnly {
    override val stackName: String = impl.stackName(): String
    override val fleetName: String = impl.fleetName(): String
    override val userId: StreamingUrlUserId =
      zio.aws.appstream.model.primitives.StreamingUrlUserId(impl.userId())
    override val applicationId: Option[String] =
      scala.Option(impl.applicationId()).map(value => value: String)
    override val validity: Option[Long] =
      scala.Option(impl.validity()).map(value => value: Long)
    override val sessionContext: Option[String] =
      scala.Option(impl.sessionContext()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateStreamingUrlRequest
  ): zio.aws.appstream.model.CreateStreamingUrlRequest.ReadOnly = new Wrapper(
    impl
  )
}
