package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.BooleanObject
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImagePermissions(
    allowFleet: Option[BooleanObject] = None,
    allowImageBuilder: Option[BooleanObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ImagePermissions = {
    import ImagePermissions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ImagePermissions
      .builder()
      .optionallyWith(
        allowFleet.map(value => BooleanObject.unwrap(value): java.lang.Boolean)
      )(_.allowFleet)
      .optionallyWith(
        allowImageBuilder.map(value =>
          BooleanObject.unwrap(value): java.lang.Boolean
        )
      )(_.allowImageBuilder)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.ImagePermissions.ReadOnly =
    zio.aws.appstream.model.ImagePermissions.wrap(buildAwsValue())
}
object ImagePermissions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ImagePermissions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ImagePermissions =
      zio.aws.appstream.model.ImagePermissions(
        allowFleet.map(value => value),
        allowImageBuilder.map(value => value)
      )
    def allowFleet: Option[BooleanObject]
    def allowImageBuilder: Option[BooleanObject]
    def getAllowFleet: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("allowFleet", allowFleet)
    def getAllowImageBuilder: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("allowImageBuilder", allowImageBuilder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ImagePermissions
  ) extends zio.aws.appstream.model.ImagePermissions.ReadOnly {
    override val allowFleet: Option[BooleanObject] = scala
      .Option(impl.allowFleet())
      .map(value => zio.aws.appstream.model.primitives.BooleanObject(value))
    override val allowImageBuilder: Option[BooleanObject] = scala
      .Option(impl.allowImageBuilder())
      .map(value => zio.aws.appstream.model.primitives.BooleanObject(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ImagePermissions
  ): zio.aws.appstream.model.ImagePermissions.ReadOnly = new Wrapper(impl)
}
