package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExpireSessionRequest(sessionId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ExpireSessionRequest = {
    import ExpireSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ExpireSessionRequest
      .builder()
      .sessionId(sessionId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.ExpireSessionRequest.ReadOnly =
    zio.aws.appstream.model.ExpireSessionRequest.wrap(buildAwsValue())
}
object ExpireSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ExpireSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ExpireSessionRequest =
      zio.aws.appstream.model.ExpireSessionRequest(sessionId)
    def sessionId: String
    def getSessionId: ZIO[Any, Nothing, String] = ZIO.succeed(sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ExpireSessionRequest
  ) extends zio.aws.appstream.model.ExpireSessionRequest.ReadOnly {
    override val sessionId: String = impl.sessionId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ExpireSessionRequest
  ): zio.aws.appstream.model.ExpireSessionRequest.ReadOnly = new Wrapper(impl)
}
