package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteImageBuilderResponse(
    imageBuilder: Option[zio.aws.appstream.model.ImageBuilder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DeleteImageBuilderResponse = {
    import DeleteImageBuilderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DeleteImageBuilderResponse
      .builder()
      .optionallyWith(imageBuilder.map(value => value.buildAwsValue()))(
        _.imageBuilder
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DeleteImageBuilderResponse.ReadOnly =
    zio.aws.appstream.model.DeleteImageBuilderResponse.wrap(buildAwsValue())
}
object DeleteImageBuilderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DeleteImageBuilderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DeleteImageBuilderResponse =
      zio.aws.appstream.model
        .DeleteImageBuilderResponse(imageBuilder.map(value => value.asEditable))
    def imageBuilder: Option[zio.aws.appstream.model.ImageBuilder.ReadOnly]
    def getImageBuilder
        : ZIO[Any, AwsError, zio.aws.appstream.model.ImageBuilder.ReadOnly] =
      AwsError.unwrapOptionField("imageBuilder", imageBuilder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DeleteImageBuilderResponse
  ) extends zio.aws.appstream.model.DeleteImageBuilderResponse.ReadOnly {
    override val imageBuilder
        : Option[zio.aws.appstream.model.ImageBuilder.ReadOnly] = scala
      .Option(impl.imageBuilder())
      .map(value => zio.aws.appstream.model.ImageBuilder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DeleteImageBuilderResponse
  ): zio.aws.appstream.model.DeleteImageBuilderResponse.ReadOnly = new Wrapper(
    impl
  )
}
