package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateStackResponse(
    stack: Option[zio.aws.appstream.model.Stack] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateStackResponse = {
    import CreateStackResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateStackResponse
      .builder()
      .optionallyWith(stack.map(value => value.buildAwsValue()))(_.stack)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateStackResponse.ReadOnly =
    zio.aws.appstream.model.CreateStackResponse.wrap(buildAwsValue())
}
object CreateStackResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateStackResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateStackResponse =
      zio.aws.appstream.model
        .CreateStackResponse(stack.map(value => value.asEditable))
    def stack: Option[zio.aws.appstream.model.Stack.ReadOnly]
    def getStack: ZIO[Any, AwsError, zio.aws.appstream.model.Stack.ReadOnly] =
      AwsError.unwrapOptionField("stack", stack)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateStackResponse
  ) extends zio.aws.appstream.model.CreateStackResponse.ReadOnly {
    override val stack: Option[zio.aws.appstream.model.Stack.ReadOnly] = scala
      .Option(impl.stack())
      .map(value => zio.aws.appstream.model.Stack.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateStackResponse
  ): zio.aws.appstream.model.CreateStackResponse.ReadOnly = new Wrapper(impl)
}
