package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait AuthenticationType {
  def unwrap: software.amazon.awssdk.services.appstream.model.AuthenticationType
}
object AuthenticationType {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.AuthenticationType
  ): zio.aws.appstream.model.AuthenticationType = value match {
    case software.amazon.awssdk.services.appstream.model.AuthenticationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.AuthenticationType.API =>
      val r = API
      r
    case software.amazon.awssdk.services.appstream.model.AuthenticationType.SAML =>
      val r = SAML
      r
    case software.amazon.awssdk.services.appstream.model.AuthenticationType.USERPOOL =>
      val r = USERPOOL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AuthenticationType =
      software.amazon.awssdk.services.appstream.model.AuthenticationType.UNKNOWN_TO_SDK_VERSION
  }
  case object API extends zio.aws.appstream.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AuthenticationType =
      software.amazon.awssdk.services.appstream.model.AuthenticationType.API
  }
  case object SAML extends zio.aws.appstream.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AuthenticationType =
      software.amazon.awssdk.services.appstream.model.AuthenticationType.SAML
  }
  case object USERPOOL extends zio.aws.appstream.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AuthenticationType =
      software.amazon.awssdk.services.appstream.model.AuthenticationType.USERPOOL
  }
}
