package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  DisplayName,
  BooleanObject,
  Arn,
  Integer,
  Description,
  UsbDeviceFilterString
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateFleetRequest(
    imageName: Option[String] = None,
    imageArn: Option[Arn] = None,
    name: Option[String] = None,
    instanceType: Option[String] = None,
    computeCapacity: Option[zio.aws.appstream.model.ComputeCapacity] = None,
    vpcConfig: Option[zio.aws.appstream.model.VpcConfig] = None,
    maxUserDurationInSeconds: Option[Integer] = None,
    disconnectTimeoutInSeconds: Option[Integer] = None,
    deleteVpcConfig: Option[Boolean] = None,
    description: Option[Description] = None,
    displayName: Option[DisplayName] = None,
    enableDefaultInternetAccess: Option[BooleanObject] = None,
    domainJoinInfo: Option[zio.aws.appstream.model.DomainJoinInfo] = None,
    idleDisconnectTimeoutInSeconds: Option[Integer] = None,
    attributesToDelete: Option[
      Iterable[zio.aws.appstream.model.FleetAttribute]
    ] = None,
    iamRoleArn: Option[Arn] = None,
    streamView: Option[zio.aws.appstream.model.StreamView] = None,
    platform: Option[zio.aws.appstream.model.PlatformType] = None,
    maxConcurrentSessions: Option[Integer] = None,
    usbDeviceFilterStrings: Option[Iterable[UsbDeviceFilterString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UpdateFleetRequest = {
    import UpdateFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UpdateFleetRequest
      .builder()
      .optionallyWith(imageName.map(value => value: java.lang.String))(
        _.imageName
      )
      .optionallyWith(
        imageArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.imageArn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(computeCapacity.map(value => value.buildAwsValue()))(
        _.computeCapacity
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        maxUserDurationInSeconds.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.maxUserDurationInSeconds)
      .optionallyWith(
        disconnectTimeoutInSeconds.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.disconnectTimeoutInSeconds)
      .optionallyWith(deleteVpcConfig.map(value => value: java.lang.Boolean))(
        _.deleteVpcConfig
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        enableDefaultInternetAccess.map(value =>
          BooleanObject.unwrap(value): java.lang.Boolean
        )
      )(_.enableDefaultInternetAccess)
      .optionallyWith(domainJoinInfo.map(value => value.buildAwsValue()))(
        _.domainJoinInfo
      )
      .optionallyWith(
        idleDisconnectTimeoutInSeconds.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.idleDisconnectTimeoutInSeconds)
      .optionallyWith(
        attributesToDelete.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.attributesToDeleteWithStrings)
      .optionallyWith(
        iamRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(streamView.map(value => value.unwrap))(_.streamView)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        maxConcurrentSessions.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.maxConcurrentSessions)
      .optionallyWith(
        usbDeviceFilterStrings.map(value =>
          value.map { item =>
            UsbDeviceFilterString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.usbDeviceFilterStrings)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.UpdateFleetRequest.ReadOnly =
    zio.aws.appstream.model.UpdateFleetRequest.wrap(buildAwsValue())
}
object UpdateFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UpdateFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UpdateFleetRequest =
      zio.aws.appstream.model.UpdateFleetRequest(
        imageName.map(value => value),
        imageArn.map(value => value),
        name.map(value => value),
        instanceType.map(value => value),
        computeCapacity.map(value => value.asEditable),
        vpcConfig.map(value => value.asEditable),
        maxUserDurationInSeconds.map(value => value),
        disconnectTimeoutInSeconds.map(value => value),
        deleteVpcConfig.map(value => value),
        description.map(value => value),
        displayName.map(value => value),
        enableDefaultInternetAccess.map(value => value),
        domainJoinInfo.map(value => value.asEditable),
        idleDisconnectTimeoutInSeconds.map(value => value),
        attributesToDelete.map(value => value),
        iamRoleArn.map(value => value),
        streamView.map(value => value),
        platform.map(value => value),
        maxConcurrentSessions.map(value => value),
        usbDeviceFilterStrings.map(value => value)
      )
    def imageName: Option[String]
    def imageArn: Option[Arn]
    def name: Option[String]
    def instanceType: Option[String]
    def computeCapacity
        : Option[zio.aws.appstream.model.ComputeCapacity.ReadOnly]
    def vpcConfig: Option[zio.aws.appstream.model.VpcConfig.ReadOnly]
    def maxUserDurationInSeconds: Option[Integer]
    def disconnectTimeoutInSeconds: Option[Integer]
    def deleteVpcConfig: Option[Boolean]
    def description: Option[Description]
    def displayName: Option[DisplayName]
    def enableDefaultInternetAccess: Option[BooleanObject]
    def domainJoinInfo: Option[zio.aws.appstream.model.DomainJoinInfo.ReadOnly]
    def idleDisconnectTimeoutInSeconds: Option[Integer]
    def attributesToDelete: Option[List[zio.aws.appstream.model.FleetAttribute]]
    def iamRoleArn: Option[Arn]
    def streamView: Option[zio.aws.appstream.model.StreamView]
    def platform: Option[zio.aws.appstream.model.PlatformType]
    def maxConcurrentSessions: Option[Integer]
    def usbDeviceFilterStrings: Option[List[UsbDeviceFilterString]]
    def getImageName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageName", imageName)
    def getImageArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("imageArn", imageArn)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getComputeCapacity
        : ZIO[Any, AwsError, zio.aws.appstream.model.ComputeCapacity.ReadOnly] =
      AwsError.unwrapOptionField("computeCapacity", computeCapacity)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.appstream.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getMaxUserDurationInSeconds: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maxUserDurationInSeconds", maxUserDurationInSeconds)
    def getDisconnectTimeoutInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "disconnectTimeoutInSeconds",
        disconnectTimeoutInSeconds
      )
    def getDeleteVpcConfig: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteVpcConfig", deleteVpcConfig)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getEnableDefaultInternetAccess: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "enableDefaultInternetAccess",
        enableDefaultInternetAccess
      )
    def getDomainJoinInfo
        : ZIO[Any, AwsError, zio.aws.appstream.model.DomainJoinInfo.ReadOnly] =
      AwsError.unwrapOptionField("domainJoinInfo", domainJoinInfo)
    def getIdleDisconnectTimeoutInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "idleDisconnectTimeoutInSeconds",
        idleDisconnectTimeoutInSeconds
      )
    def getAttributesToDelete
        : ZIO[Any, AwsError, List[zio.aws.appstream.model.FleetAttribute]] =
      AwsError.unwrapOptionField("attributesToDelete", attributesToDelete)
    def getIamRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getStreamView: ZIO[Any, AwsError, zio.aws.appstream.model.StreamView] =
      AwsError.unwrapOptionField("streamView", streamView)
    def getPlatform: ZIO[Any, AwsError, zio.aws.appstream.model.PlatformType] =
      AwsError.unwrapOptionField("platform", platform)
    def getMaxConcurrentSessions: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxConcurrentSessions", maxConcurrentSessions)
    def getUsbDeviceFilterStrings
        : ZIO[Any, AwsError, List[UsbDeviceFilterString]] = AwsError
      .unwrapOptionField("usbDeviceFilterStrings", usbDeviceFilterStrings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UpdateFleetRequest
  ) extends zio.aws.appstream.model.UpdateFleetRequest.ReadOnly {
    override val imageName: Option[String] =
      scala.Option(impl.imageName()).map(value => value: String)
    override val imageArn: Option[Arn] = scala
      .Option(impl.imageArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val instanceType: Option[String] =
      scala.Option(impl.instanceType()).map(value => value: String)
    override val computeCapacity
        : Option[zio.aws.appstream.model.ComputeCapacity.ReadOnly] = scala
      .Option(impl.computeCapacity())
      .map(value => zio.aws.appstream.model.ComputeCapacity.wrap(value))
    override val vpcConfig: Option[zio.aws.appstream.model.VpcConfig.ReadOnly] =
      scala
        .Option(impl.vpcConfig())
        .map(value => zio.aws.appstream.model.VpcConfig.wrap(value))
    override val maxUserDurationInSeconds: Option[Integer] = scala
      .Option(impl.maxUserDurationInSeconds())
      .map(value => zio.aws.appstream.model.primitives.Integer(value))
    override val disconnectTimeoutInSeconds: Option[Integer] = scala
      .Option(impl.disconnectTimeoutInSeconds())
      .map(value => zio.aws.appstream.model.primitives.Integer(value))
    override val deleteVpcConfig: Option[Boolean] =
      scala.Option(impl.deleteVpcConfig()).map(value => value: Boolean)
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appstream.model.primitives.Description(value))
    override val displayName: Option[DisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.appstream.model.primitives.DisplayName(value))
    override val enableDefaultInternetAccess: Option[BooleanObject] = scala
      .Option(impl.enableDefaultInternetAccess())
      .map(value => zio.aws.appstream.model.primitives.BooleanObject(value))
    override val domainJoinInfo
        : Option[zio.aws.appstream.model.DomainJoinInfo.ReadOnly] = scala
      .Option(impl.domainJoinInfo())
      .map(value => zio.aws.appstream.model.DomainJoinInfo.wrap(value))
    override val idleDisconnectTimeoutInSeconds: Option[Integer] = scala
      .Option(impl.idleDisconnectTimeoutInSeconds())
      .map(value => zio.aws.appstream.model.primitives.Integer(value))
    override val attributesToDelete
        : Option[List[zio.aws.appstream.model.FleetAttribute]] = scala
      .Option(impl.attributesToDelete())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.FleetAttribute.wrap(item)
        }.toList
      )
    override val iamRoleArn: Option[Arn] = scala
      .Option(impl.iamRoleArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val streamView: Option[zio.aws.appstream.model.StreamView] = scala
      .Option(impl.streamView())
      .map(value => zio.aws.appstream.model.StreamView.wrap(value))
    override val platform: Option[zio.aws.appstream.model.PlatformType] = scala
      .Option(impl.platform())
      .map(value => zio.aws.appstream.model.PlatformType.wrap(value))
    override val maxConcurrentSessions: Option[Integer] = scala
      .Option(impl.maxConcurrentSessions())
      .map(value => zio.aws.appstream.model.primitives.Integer(value))
    override val usbDeviceFilterStrings: Option[List[UsbDeviceFilterString]] =
      scala
        .Option(impl.usbDeviceFilterStrings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.primitives.UsbDeviceFilterString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UpdateFleetRequest
  ): zio.aws.appstream.model.UpdateFleetRequest.ReadOnly = new Wrapper(impl)
}
