package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateEntitlementResponse(
    entitlement: Option[zio.aws.appstream.model.Entitlement] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UpdateEntitlementResponse = {
    import UpdateEntitlementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UpdateEntitlementResponse
      .builder()
      .optionallyWith(entitlement.map(value => value.buildAwsValue()))(
        _.entitlement
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.UpdateEntitlementResponse.ReadOnly =
    zio.aws.appstream.model.UpdateEntitlementResponse.wrap(buildAwsValue())
}
object UpdateEntitlementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UpdateEntitlementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UpdateEntitlementResponse =
      zio.aws.appstream.model
        .UpdateEntitlementResponse(entitlement.map(value => value.asEditable))
    def entitlement: Option[zio.aws.appstream.model.Entitlement.ReadOnly]
    def getEntitlement
        : ZIO[Any, AwsError, zio.aws.appstream.model.Entitlement.ReadOnly] =
      AwsError.unwrapOptionField("entitlement", entitlement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UpdateEntitlementResponse
  ) extends zio.aws.appstream.model.UpdateEntitlementResponse.ReadOnly {
    override val entitlement
        : Option[zio.aws.appstream.model.Entitlement.ReadOnly] = scala
      .Option(impl.entitlement())
      .map(value => zio.aws.appstream.model.Entitlement.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UpdateEntitlementResponse
  ): zio.aws.appstream.model.UpdateEntitlementResponse.ReadOnly = new Wrapper(
    impl
  )
}
