package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ResourceError(
    errorCode: Option[zio.aws.appstream.model.FleetErrorCode] = None,
    errorMessage: Option[String] = None,
    errorTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ResourceError = {
    import ResourceError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ResourceError
      .builder()
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(
        errorTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.errorTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.ResourceError.ReadOnly =
    zio.aws.appstream.model.ResourceError.wrap(buildAwsValue())
}
object ResourceError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ResourceError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ResourceError =
      zio.aws.appstream.model.ResourceError(
        errorCode.map(value => value),
        errorMessage.map(value => value),
        errorTimestamp.map(value => value)
      )
    def errorCode: Option[zio.aws.appstream.model.FleetErrorCode]
    def errorMessage: Option[String]
    def errorTimestamp: Option[Timestamp]
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.appstream.model.FleetErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getErrorTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("errorTimestamp", errorTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ResourceError
  ) extends zio.aws.appstream.model.ResourceError.ReadOnly {
    override val errorCode: Option[zio.aws.appstream.model.FleetErrorCode] =
      scala
        .Option(impl.errorCode())
        .map(value => zio.aws.appstream.model.FleetErrorCode.wrap(value))
    override val errorMessage: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
    override val errorTimestamp: Option[Timestamp] = scala
      .Option(impl.errorTimestamp())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ResourceError
  ): zio.aws.appstream.model.ResourceError.ReadOnly = new Wrapper(impl)
}
