package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LastReportGenerationExecutionError(
    errorCode: Option[zio.aws.appstream.model.UsageReportExecutionErrorCode] =
      None,
    errorMessage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.LastReportGenerationExecutionError = {
    import LastReportGenerationExecutionError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.LastReportGenerationExecutionError
      .builder()
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.LastReportGenerationExecutionError.ReadOnly =
    zio.aws.appstream.model.LastReportGenerationExecutionError
      .wrap(buildAwsValue())
}
object LastReportGenerationExecutionError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.LastReportGenerationExecutionError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.LastReportGenerationExecutionError =
      zio.aws.appstream.model.LastReportGenerationExecutionError(
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def errorCode: Option[zio.aws.appstream.model.UsageReportExecutionErrorCode]
    def errorMessage: Option[String]
    def getErrorCode: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.UsageReportExecutionErrorCode
    ] = AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.LastReportGenerationExecutionError
  ) extends zio.aws.appstream.model.LastReportGenerationExecutionError.ReadOnly {
    override val errorCode
        : Option[zio.aws.appstream.model.UsageReportExecutionErrorCode] = scala
      .Option(impl.errorCode())
      .map(value =>
        zio.aws.appstream.model.UsageReportExecutionErrorCode.wrap(value)
      )
    override val errorMessage: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.LastReportGenerationExecutionError
  ): zio.aws.appstream.model.LastReportGenerationExecutionError.ReadOnly =
    new Wrapper(impl)
}
