package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EntitledApplication(applicationIdentifier: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.EntitledApplication = {
    import EntitledApplication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.EntitledApplication
      .builder()
      .applicationIdentifier(applicationIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.EntitledApplication.ReadOnly =
    zio.aws.appstream.model.EntitledApplication.wrap(buildAwsValue())
}
object EntitledApplication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.EntitledApplication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.EntitledApplication =
      zio.aws.appstream.model.EntitledApplication(applicationIdentifier)
    def applicationIdentifier: String
    def getApplicationIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(applicationIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.EntitledApplication
  ) extends zio.aws.appstream.model.EntitledApplication.ReadOnly {
    override val applicationIdentifier: String =
      impl.applicationIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.EntitledApplication
  ): zio.aws.appstream.model.EntitledApplication.ReadOnly = new Wrapper(impl)
}
