package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{Integer, DirectoryName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDirectoryConfigsRequest(
    directoryNames: Option[Iterable[DirectoryName]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsRequest = {
    import DescribeDirectoryConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsRequest
      .builder()
      .optionallyWith(
        directoryNames.map(value =>
          value.map { item =>
            DirectoryName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.directoryNames)
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DescribeDirectoryConfigsRequest.ReadOnly =
    zio.aws.appstream.model.DescribeDirectoryConfigsRequest
      .wrap(buildAwsValue())
}
object DescribeDirectoryConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeDirectoryConfigsRequest =
      zio.aws.appstream.model.DescribeDirectoryConfigsRequest(
        directoryNames.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def directoryNames: Option[List[DirectoryName]]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def getDirectoryNames: ZIO[Any, AwsError, List[DirectoryName]] =
      AwsError.unwrapOptionField("directoryNames", directoryNames)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsRequest
  ) extends zio.aws.appstream.model.DescribeDirectoryConfigsRequest.ReadOnly {
    override val directoryNames: Option[List[DirectoryName]] = scala
      .Option(impl.directoryNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.primitives.DirectoryName(item)
        }.toList
      )
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.appstream.model.primitives.Integer(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsRequest
  ): zio.aws.appstream.model.DescribeDirectoryConfigsRequest.ReadOnly =
    new Wrapper(impl)
}
