package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AccessEndpoint(
    endpointType: zio.aws.appstream.model.AccessEndpointType,
    vpceId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.AccessEndpoint = {
    import AccessEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.AccessEndpoint
      .builder()
      .endpointType(endpointType.unwrap)
      .optionallyWith(vpceId.map(value => value: java.lang.String))(_.vpceId)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.AccessEndpoint.ReadOnly =
    zio.aws.appstream.model.AccessEndpoint.wrap(buildAwsValue())
}
object AccessEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.AccessEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.AccessEndpoint =
      zio.aws.appstream.model
        .AccessEndpoint(endpointType, vpceId.map(value => value))
    def endpointType: zio.aws.appstream.model.AccessEndpointType
    def vpceId: Option[String]
    def getEndpointType
        : ZIO[Any, Nothing, zio.aws.appstream.model.AccessEndpointType] =
      ZIO.succeed(endpointType)
    def getVpceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpceId", vpceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.AccessEndpoint
  ) extends zio.aws.appstream.model.AccessEndpoint.ReadOnly {
    override val endpointType: zio.aws.appstream.model.AccessEndpointType =
      zio.aws.appstream.model.AccessEndpointType.wrap(impl.endpointType())
    override val vpceId: Option[String] =
      scala.Option(impl.vpceId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.AccessEndpoint
  ): zio.aws.appstream.model.AccessEndpoint.ReadOnly = new Wrapper(impl)
}
