package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  Timestamp,
  UserAttributeValue,
  Username,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class User(
    arn: Option[Arn] = None,
    userName: Option[Username] = None,
    enabled: Option[Boolean] = None,
    status: Option[String] = None,
    firstName: Option[UserAttributeValue] = None,
    lastName: Option[UserAttributeValue] = None,
    createdTime: Option[Timestamp] = None,
    authenticationType: zio.aws.appstream.model.AuthenticationType
) {
  def buildAwsValue(): software.amazon.awssdk.services.appstream.model.User = {
    import User.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.User
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        userName.map(value => Username.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        firstName.map(value =>
          UserAttributeValue.unwrap(value): java.lang.String
        )
      )(_.firstName)
      .optionallyWith(
        lastName.map(value =>
          UserAttributeValue.unwrap(value): java.lang.String
        )
      )(_.lastName)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .authenticationType(authenticationType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.User.ReadOnly =
    zio.aws.appstream.model.User.wrap(buildAwsValue())
}
object User {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appstream.model.User] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.User = zio.aws.appstream.model.User(
      arn.map(value => value),
      userName.map(value => value),
      enabled.map(value => value),
      status.map(value => value),
      firstName.map(value => value),
      lastName.map(value => value),
      createdTime.map(value => value),
      authenticationType
    )
    def arn: Option[Arn]
    def userName: Option[Username]
    def enabled: Option[Boolean]
    def status: Option[String]
    def firstName: Option[UserAttributeValue]
    def lastName: Option[UserAttributeValue]
    def createdTime: Option[Timestamp]
    def authenticationType: zio.aws.appstream.model.AuthenticationType
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getUserName: ZIO[Any, AwsError, Username] =
      AwsError.unwrapOptionField("userName", userName)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getFirstName: ZIO[Any, AwsError, UserAttributeValue] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, UserAttributeValue] =
      AwsError.unwrapOptionField("lastName", lastName)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getAuthenticationType
        : ZIO[Any, Nothing, zio.aws.appstream.model.AuthenticationType] =
      ZIO.succeed(authenticationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.User
  ) extends zio.aws.appstream.model.User.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val userName: Option[Username] = scala
      .Option(impl.userName())
      .map(value => zio.aws.appstream.model.primitives.Username(value))
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val firstName: Option[UserAttributeValue] = scala
      .Option(impl.firstName())
      .map(value =>
        zio.aws.appstream.model.primitives.UserAttributeValue(value)
      )
    override val lastName: Option[UserAttributeValue] = scala
      .Option(impl.lastName())
      .map(value =>
        zio.aws.appstream.model.primitives.UserAttributeValue(value)
      )
    override val createdTime: Option[Timestamp] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
    override val authenticationType
        : zio.aws.appstream.model.AuthenticationType =
      zio.aws.appstream.model.AuthenticationType.wrap(impl.authenticationType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.User
  ): zio.aws.appstream.model.User.ReadOnly = new Wrapper(impl)
}
