package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{Integer, UserId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSessionsRequest(
    stackName: String,
    fleetName: String,
    userId: Option[UserId] = None,
    nextToken: Option[String] = None,
    limit: Option[Integer] = None,
    authenticationType: Option[zio.aws.appstream.model.AuthenticationType] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeSessionsRequest = {
    import DescribeSessionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeSessionsRequest
      .builder()
      .stackName(stackName: java.lang.String)
      .fleetName(fleetName: java.lang.String)
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        limit.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.limit)
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DescribeSessionsRequest.ReadOnly =
    zio.aws.appstream.model.DescribeSessionsRequest.wrap(buildAwsValue())
}
object DescribeSessionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeSessionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeSessionsRequest =
      zio.aws.appstream.model.DescribeSessionsRequest(
        stackName,
        fleetName,
        userId.map(value => value),
        nextToken.map(value => value),
        limit.map(value => value),
        authenticationType.map(value => value)
      )
    def stackName: String
    def fleetName: String
    def userId: Option[UserId]
    def nextToken: Option[String]
    def limit: Option[Integer]
    def authenticationType: Option[zio.aws.appstream.model.AuthenticationType]
    def getStackName: ZIO[Any, Nothing, String] = ZIO.succeed(stackName)
    def getFleetName: ZIO[Any, Nothing, String] = ZIO.succeed(fleetName)
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLimit: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("limit", limit)
    def getAuthenticationType
        : ZIO[Any, AwsError, zio.aws.appstream.model.AuthenticationType] =
      AwsError.unwrapOptionField("authenticationType", authenticationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeSessionsRequest
  ) extends zio.aws.appstream.model.DescribeSessionsRequest.ReadOnly {
    override val stackName: String = impl.stackName(): String
    override val fleetName: String = impl.fleetName(): String
    override val userId: Option[UserId] = scala
      .Option(impl.userId())
      .map(value => zio.aws.appstream.model.primitives.UserId(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val limit: Option[Integer] = scala
      .Option(impl.limit())
      .map(value => zio.aws.appstream.model.primitives.Integer(value))
    override val authenticationType
        : Option[zio.aws.appstream.model.AuthenticationType] = scala
      .Option(impl.authenticationType())
      .map(value => zio.aws.appstream.model.AuthenticationType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeSessionsRequest
  ): zio.aws.appstream.model.DescribeSessionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
