package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{UserAttributeValue, Username}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateUserRequest(
    userName: Username,
    messageAction: Option[zio.aws.appstream.model.MessageAction] = None,
    firstName: Option[UserAttributeValue] = None,
    lastName: Option[UserAttributeValue] = None,
    authenticationType: zio.aws.appstream.model.AuthenticationType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateUserRequest = {
    import CreateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateUserRequest
      .builder()
      .userName(Username.unwrap(userName): java.lang.String)
      .optionallyWith(messageAction.map(value => value.unwrap))(_.messageAction)
      .optionallyWith(
        firstName.map(value =>
          UserAttributeValue.unwrap(value): java.lang.String
        )
      )(_.firstName)
      .optionallyWith(
        lastName.map(value =>
          UserAttributeValue.unwrap(value): java.lang.String
        )
      )(_.lastName)
      .authenticationType(authenticationType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateUserRequest.ReadOnly =
    zio.aws.appstream.model.CreateUserRequest.wrap(buildAwsValue())
}
object CreateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateUserRequest =
      zio.aws.appstream.model.CreateUserRequest(
        userName,
        messageAction.map(value => value),
        firstName.map(value => value),
        lastName.map(value => value),
        authenticationType
      )
    def userName: Username
    def messageAction: Option[zio.aws.appstream.model.MessageAction]
    def firstName: Option[UserAttributeValue]
    def lastName: Option[UserAttributeValue]
    def authenticationType: zio.aws.appstream.model.AuthenticationType
    def getUserName: ZIO[Any, Nothing, Username] = ZIO.succeed(userName)
    def getMessageAction
        : ZIO[Any, AwsError, zio.aws.appstream.model.MessageAction] =
      AwsError.unwrapOptionField("messageAction", messageAction)
    def getFirstName: ZIO[Any, AwsError, UserAttributeValue] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, UserAttributeValue] =
      AwsError.unwrapOptionField("lastName", lastName)
    def getAuthenticationType
        : ZIO[Any, Nothing, zio.aws.appstream.model.AuthenticationType] =
      ZIO.succeed(authenticationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateUserRequest
  ) extends zio.aws.appstream.model.CreateUserRequest.ReadOnly {
    override val userName: Username =
      zio.aws.appstream.model.primitives.Username(impl.userName())
    override val messageAction: Option[zio.aws.appstream.model.MessageAction] =
      scala
        .Option(impl.messageAction())
        .map(value => zio.aws.appstream.model.MessageAction.wrap(value))
    override val firstName: Option[UserAttributeValue] = scala
      .Option(impl.firstName())
      .map(value =>
        zio.aws.appstream.model.primitives.UserAttributeValue(value)
      )
    override val lastName: Option[UserAttributeValue] = scala
      .Option(impl.lastName())
      .map(value =>
        zio.aws.appstream.model.primitives.UserAttributeValue(value)
      )
    override val authenticationType
        : zio.aws.appstream.model.AuthenticationType =
      zio.aws.appstream.model.AuthenticationType.wrap(impl.authenticationType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateUserRequest
  ): zio.aws.appstream.model.CreateUserRequest.ReadOnly = new Wrapper(impl)
}
