package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateEntitlementResponse(
    entitlement: Option[zio.aws.appstream.model.Entitlement] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateEntitlementResponse = {
    import CreateEntitlementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateEntitlementResponse
      .builder()
      .optionallyWith(entitlement.map(value => value.buildAwsValue()))(
        _.entitlement
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateEntitlementResponse.ReadOnly =
    zio.aws.appstream.model.CreateEntitlementResponse.wrap(buildAwsValue())
}
object CreateEntitlementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateEntitlementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateEntitlementResponse =
      zio.aws.appstream.model
        .CreateEntitlementResponse(entitlement.map(value => value.asEditable))
    def entitlement: Option[zio.aws.appstream.model.Entitlement.ReadOnly]
    def getEntitlement
        : ZIO[Any, AwsError, zio.aws.appstream.model.Entitlement.ReadOnly] =
      AwsError.unwrapOptionField("entitlement", entitlement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateEntitlementResponse
  ) extends zio.aws.appstream.model.CreateEntitlementResponse.ReadOnly {
    override val entitlement
        : Option[zio.aws.appstream.model.Entitlement.ReadOnly] = scala
      .Option(impl.entitlement())
      .map(value => zio.aws.appstream.model.Entitlement.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateEntitlementResponse
  ): zio.aws.appstream.model.CreateEntitlementResponse.ReadOnly = new Wrapper(
    impl
  )
}
