package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ComputeCapacityStatus(
    desired: Integer,
    running: Option[Integer] = None,
    inUse: Option[Integer] = None,
    available: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ComputeCapacityStatus = {
    import ComputeCapacityStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ComputeCapacityStatus
      .builder()
      .desired(Integer.unwrap(desired): java.lang.Integer)
      .optionallyWith(
        running.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.running)
      .optionallyWith(
        inUse.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.inUse)
      .optionallyWith(
        available.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.available)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.ComputeCapacityStatus.ReadOnly =
    zio.aws.appstream.model.ComputeCapacityStatus.wrap(buildAwsValue())
}
object ComputeCapacityStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ComputeCapacityStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ComputeCapacityStatus =
      zio.aws.appstream.model.ComputeCapacityStatus(
        desired,
        running.map(value => value),
        inUse.map(value => value),
        available.map(value => value)
      )
    def desired: Integer
    def running: Option[Integer]
    def inUse: Option[Integer]
    def available: Option[Integer]
    def getDesired: ZIO[Any, Nothing, Integer] = ZIO.succeed(desired)
    def getRunning: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("running", running)
    def getInUse: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("inUse", inUse)
    def getAvailable: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("available", available)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ComputeCapacityStatus
  ) extends zio.aws.appstream.model.ComputeCapacityStatus.ReadOnly {
    override val desired: Integer =
      zio.aws.appstream.model.primitives.Integer(impl.desired())
    override val running: Option[Integer] = scala
      .Option(impl.running())
      .map(value => zio.aws.appstream.model.primitives.Integer(value))
    override val inUse: Option[Integer] = scala
      .Option(impl.inUse())
      .map(value => zio.aws.appstream.model.primitives.Integer(value))
    override val available: Option[Integer] = scala
      .Option(impl.available())
      .map(value => zio.aws.appstream.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ComputeCapacityStatus
  ): zio.aws.appstream.model.ComputeCapacityStatus.ReadOnly = new Wrapper(impl)
}
