package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  DisplayName,
  Description,
  RedirectURL,
  EmbedHostDomain,
  FeedbackURL
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateStackRequest(
    displayName: Option[DisplayName] = None,
    description: Option[Description] = None,
    name: String,
    storageConnectors: Option[
      Iterable[zio.aws.appstream.model.StorageConnector]
    ] = None,
    deleteStorageConnectors: Option[Boolean] = None,
    redirectURL: Option[RedirectURL] = None,
    feedbackURL: Option[FeedbackURL] = None,
    attributesToDelete: Option[
      Iterable[zio.aws.appstream.model.StackAttribute]
    ] = None,
    userSettings: Option[Iterable[zio.aws.appstream.model.UserSetting]] = None,
    applicationSettings: Option[zio.aws.appstream.model.ApplicationSettings] =
      None,
    accessEndpoints: Option[Iterable[zio.aws.appstream.model.AccessEndpoint]] =
      None,
    embedHostDomains: Option[Iterable[EmbedHostDomain]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UpdateStackRequest = {
    import UpdateStackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UpdateStackRequest
      .builder()
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .name(name: java.lang.String)
      .optionallyWith(
        storageConnectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageConnectors)
      .optionallyWith(
        deleteStorageConnectors.map(value => value: java.lang.Boolean)
      )(_.deleteStorageConnectors)
      .optionallyWith(
        redirectURL.map(value => RedirectURL.unwrap(value): java.lang.String)
      )(_.redirectURL)
      .optionallyWith(
        feedbackURL.map(value => FeedbackURL.unwrap(value): java.lang.String)
      )(_.feedbackURL)
      .optionallyWith(
        attributesToDelete.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.attributesToDeleteWithStrings)
      .optionallyWith(
        userSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userSettings)
      .optionallyWith(applicationSettings.map(value => value.buildAwsValue()))(
        _.applicationSettings
      )
      .optionallyWith(
        accessEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessEndpoints)
      .optionallyWith(
        embedHostDomains.map(value =>
          value.map { item =>
            EmbedHostDomain.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.embedHostDomains)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.UpdateStackRequest.ReadOnly =
    zio.aws.appstream.model.UpdateStackRequest.wrap(buildAwsValue())
}
object UpdateStackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UpdateStackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UpdateStackRequest =
      zio.aws.appstream.model.UpdateStackRequest(
        displayName.map(value => value),
        description.map(value => value),
        name,
        storageConnectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deleteStorageConnectors.map(value => value),
        redirectURL.map(value => value),
        feedbackURL.map(value => value),
        attributesToDelete.map(value => value),
        userSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        applicationSettings.map(value => value.asEditable),
        accessEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        embedHostDomains.map(value => value)
      )
    def displayName: Option[DisplayName]
    def description: Option[Description]
    def name: String
    def storageConnectors
        : Option[List[zio.aws.appstream.model.StorageConnector.ReadOnly]]
    def deleteStorageConnectors: Option[Boolean]
    def redirectURL: Option[RedirectURL]
    def feedbackURL: Option[FeedbackURL]
    def attributesToDelete: Option[List[zio.aws.appstream.model.StackAttribute]]
    def userSettings: Option[List[zio.aws.appstream.model.UserSetting.ReadOnly]]
    def applicationSettings
        : Option[zio.aws.appstream.model.ApplicationSettings.ReadOnly]
    def accessEndpoints
        : Option[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]]
    def embedHostDomains: Option[List[EmbedHostDomain]]
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getStorageConnectors: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.StorageConnector.ReadOnly
    ]] = AwsError.unwrapOptionField("storageConnectors", storageConnectors)
    def getDeleteStorageConnectors: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("deleteStorageConnectors", deleteStorageConnectors)
    def getRedirectURL: ZIO[Any, AwsError, RedirectURL] =
      AwsError.unwrapOptionField("redirectURL", redirectURL)
    def getFeedbackURL: ZIO[Any, AwsError, FeedbackURL] =
      AwsError.unwrapOptionField("feedbackURL", feedbackURL)
    def getAttributesToDelete
        : ZIO[Any, AwsError, List[zio.aws.appstream.model.StackAttribute]] =
      AwsError.unwrapOptionField("attributesToDelete", attributesToDelete)
    def getUserSettings: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.UserSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("userSettings", userSettings)
    def getApplicationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.ApplicationSettings.ReadOnly
    ] = AwsError.unwrapOptionField("applicationSettings", applicationSettings)
    def getAccessEndpoints: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.AccessEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("accessEndpoints", accessEndpoints)
    def getEmbedHostDomains: ZIO[Any, AwsError, List[EmbedHostDomain]] =
      AwsError.unwrapOptionField("embedHostDomains", embedHostDomains)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UpdateStackRequest
  ) extends zio.aws.appstream.model.UpdateStackRequest.ReadOnly {
    override val displayName: Option[DisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.appstream.model.primitives.DisplayName(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appstream.model.primitives.Description(value))
    override val name: String = impl.name(): String
    override val storageConnectors
        : Option[List[zio.aws.appstream.model.StorageConnector.ReadOnly]] =
      scala
        .Option(impl.storageConnectors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.StorageConnector.wrap(item)
          }.toList
        )
    override val deleteStorageConnectors: Option[Boolean] =
      scala.Option(impl.deleteStorageConnectors()).map(value => value: Boolean)
    override val redirectURL: Option[RedirectURL] = scala
      .Option(impl.redirectURL())
      .map(value => zio.aws.appstream.model.primitives.RedirectURL(value))
    override val feedbackURL: Option[FeedbackURL] = scala
      .Option(impl.feedbackURL())
      .map(value => zio.aws.appstream.model.primitives.FeedbackURL(value))
    override val attributesToDelete
        : Option[List[zio.aws.appstream.model.StackAttribute]] = scala
      .Option(impl.attributesToDelete())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.StackAttribute.wrap(item)
        }.toList
      )
    override val userSettings
        : Option[List[zio.aws.appstream.model.UserSetting.ReadOnly]] = scala
      .Option(impl.userSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.UserSetting.wrap(item)
        }.toList
      )
    override val applicationSettings
        : Option[zio.aws.appstream.model.ApplicationSettings.ReadOnly] = scala
      .Option(impl.applicationSettings())
      .map(value => zio.aws.appstream.model.ApplicationSettings.wrap(value))
    override val accessEndpoints
        : Option[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]] = scala
      .Option(impl.accessEndpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.AccessEndpoint.wrap(item)
        }.toList
      )
    override val embedHostDomains: Option[List[EmbedHostDomain]] = scala
      .Option(impl.embedHostDomains())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.primitives.EmbedHostDomain(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UpdateStackRequest
  ): zio.aws.appstream.model.UpdateStackRequest.ReadOnly = new Wrapper(impl)
}
