package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{Integer, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListEntitledApplicationsRequest(
    stackName: Name,
    entitlementName: Name,
    nextToken: Option[String] = None,
    maxResults: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ListEntitledApplicationsRequest = {
    import ListEntitledApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ListEntitledApplicationsRequest
      .builder()
      .stackName(Name.unwrap(stackName): java.lang.String)
      .entitlementName(Name.unwrap(entitlementName): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.ListEntitledApplicationsRequest.ReadOnly =
    zio.aws.appstream.model.ListEntitledApplicationsRequest
      .wrap(buildAwsValue())
}
object ListEntitledApplicationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ListEntitledApplicationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ListEntitledApplicationsRequest =
      zio.aws.appstream.model.ListEntitledApplicationsRequest(
        stackName,
        entitlementName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def stackName: Name
    def entitlementName: Name
    def nextToken: Option[String]
    def maxResults: Option[Integer]
    def getStackName: ZIO[Any, Nothing, Name] = ZIO.succeed(stackName)
    def getEntitlementName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(entitlementName)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ListEntitledApplicationsRequest
  ) extends zio.aws.appstream.model.ListEntitledApplicationsRequest.ReadOnly {
    override val stackName: Name =
      zio.aws.appstream.model.primitives.Name(impl.stackName())
    override val entitlementName: Name =
      zio.aws.appstream.model.primitives.Name(impl.entitlementName())
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.appstream.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ListEntitledApplicationsRequest
  ): zio.aws.appstream.model.ListEntitledApplicationsRequest.ReadOnly =
    new Wrapper(impl)
}
