package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDisassociateUserStackRequest(
    userStackAssociations: Iterable[
      zio.aws.appstream.model.UserStackAssociation
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.BatchDisassociateUserStackRequest = {
    import BatchDisassociateUserStackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.BatchDisassociateUserStackRequest
      .builder()
      .userStackAssociations(userStackAssociations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.BatchDisassociateUserStackRequest.ReadOnly =
    zio.aws.appstream.model.BatchDisassociateUserStackRequest
      .wrap(buildAwsValue())
}
object BatchDisassociateUserStackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.BatchDisassociateUserStackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.BatchDisassociateUserStackRequest =
      zio.aws.appstream.model
        .BatchDisassociateUserStackRequest(userStackAssociations.map { item =>
          item.asEditable
        })
    def userStackAssociations
        : List[zio.aws.appstream.model.UserStackAssociation.ReadOnly]
    def getUserStackAssociations: ZIO[Any, Nothing, List[
      zio.aws.appstream.model.UserStackAssociation.ReadOnly
    ]] = ZIO.succeed(userStackAssociations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.BatchDisassociateUserStackRequest
  ) extends zio.aws.appstream.model.BatchDisassociateUserStackRequest.ReadOnly {
    override val userStackAssociations
        : List[zio.aws.appstream.model.UserStackAssociation.ReadOnly] = impl
      .userStackAssociations()
      .asScala
      .map { item =>
        zio.aws.appstream.model.UserStackAssociation.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.BatchDisassociateUserStackRequest
  ): zio.aws.appstream.model.BatchDisassociateUserStackRequest.ReadOnly =
    new Wrapper(impl)
}
