package zio.aws.appstream
import zio.prelude.Subtype
import zio.aws.appstream.model.primitives.{
  Domain,
  DirectoryName,
  TagValue,
  Arn,
  OrganizationalUnitDistinguishedName,
  UsbDeviceFilterString,
  EmbedHostDomain,
  AwsAccountId,
  TagKey
}
import java.time.Instant
import zio.aws.appstream.model.primitives.Username.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccountName extends Subtype[String]
    type AccountName = zio.aws.appstream.model.primitives.AccountName.Type
    object AccountPassword extends Subtype[String]
    type AccountPassword =
      zio.aws.appstream.model.primitives.AccountPassword.Type
    object AppstreamAgentVersion extends Subtype[String]
    type AppstreamAgentVersion =
      zio.aws.appstream.model.primitives.AppstreamAgentVersion.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.appstream.model.primitives.Arn.Type
    object AwsAccountId extends Subtype[String]
    type AwsAccountId = zio.aws.appstream.model.primitives.AwsAccountId.Type
    object BooleanObject extends Subtype[Boolean]
    type BooleanObject = zio.aws.appstream.model.primitives.BooleanObject.Type
    object DescribeImagesMaxResults extends Subtype[Int]
    type DescribeImagesMaxResults =
      zio.aws.appstream.model.primitives.DescribeImagesMaxResults.Type
    object Description extends Subtype[String]
    type Description = zio.aws.appstream.model.primitives.Description.Type
    object DirectoryName extends Subtype[String]
    type DirectoryName = zio.aws.appstream.model.primitives.DirectoryName.Type
    object DisplayName extends Subtype[String]
    type DisplayName = zio.aws.appstream.model.primitives.DisplayName.Type
    object Domain extends Subtype[String]
    type Domain = zio.aws.appstream.model.primitives.Domain.Type
    object EmbedHostDomain extends Subtype[String]
    type EmbedHostDomain =
      zio.aws.appstream.model.primitives.EmbedHostDomain.Type
    object FeedbackURL extends Subtype[String]
    type FeedbackURL = zio.aws.appstream.model.primitives.FeedbackURL.Type
    object Integer extends Subtype[Int]
    type Integer = zio.aws.appstream.model.primitives.Integer.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.appstream.model.primitives.MaxResults.Type
    object Name extends Subtype[String]
    type Name = zio.aws.appstream.model.primitives.Name.Type
    object OrganizationalUnitDistinguishedName extends Subtype[String]
    type OrganizationalUnitDistinguishedName =
      zio.aws.appstream.model.primitives.OrganizationalUnitDistinguishedName.Type
    object RedirectURL extends Subtype[String]
    type RedirectURL = zio.aws.appstream.model.primitives.RedirectURL.Type
    object RegionName extends Subtype[String]
    type RegionName = zio.aws.appstream.model.primitives.RegionName.Type
    object ResourceIdentifier extends Subtype[String]
    type ResourceIdentifier =
      zio.aws.appstream.model.primitives.ResourceIdentifier.Type
    object S3Bucket extends Subtype[String]
    type S3Bucket = zio.aws.appstream.model.primitives.S3Bucket.Type
    object S3Key extends Subtype[String]
    type S3Key = zio.aws.appstream.model.primitives.S3Key.Type
    object SettingsGroup extends Subtype[String]
    type SettingsGroup = zio.aws.appstream.model.primitives.SettingsGroup.Type
    object StreamingUrlUserId extends Subtype[String]
    type StreamingUrlUserId =
      zio.aws.appstream.model.primitives.StreamingUrlUserId.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.appstream.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.appstream.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.appstream.model.primitives.Timestamp.Type
    object UsbDeviceFilterString extends Subtype[String]
    type UsbDeviceFilterString =
      zio.aws.appstream.model.primitives.UsbDeviceFilterString.Type
    object UserAttributeValue extends Subtype[String]
    type UserAttributeValue =
      zio.aws.appstream.model.primitives.UserAttributeValue.Type
    object UserId extends Subtype[String]
    type UserId = zio.aws.appstream.model.primitives.UserId.Type
    object Username extends Subtype[String]
    type Username = zio.aws.appstream.model.primitives.Username.Type
  }
  type AccessEndpointList = List[zio.aws.appstream.model.AccessEndpoint]
  type AppBlocks = List[zio.aws.appstream.model.AppBlock]
  type ApplicationAttributes =
    List[zio.aws.appstream.model.ApplicationAttribute]
  type ApplicationFleetAssociationList =
    List[zio.aws.appstream.model.ApplicationFleetAssociation]
  type Applications = List[zio.aws.appstream.model.Application]
  type ArnList = List[Arn]
  type AwsAccountIdList = List[AwsAccountId]
  type DirectoryConfigList = List[zio.aws.appstream.model.DirectoryConfig]
  type DirectoryNameList = List[DirectoryName]
  type DomainList = List[Domain]
  type EmbedHostDomains = List[EmbedHostDomain]
  type EntitledApplicationList =
    List[zio.aws.appstream.model.EntitledApplication]
  type EntitlementAttributeList =
    List[zio.aws.appstream.model.EntitlementAttribute]
  type EntitlementList = List[zio.aws.appstream.model.Entitlement]
  type FleetAttributes = List[zio.aws.appstream.model.FleetAttribute]
  type FleetErrors = List[zio.aws.appstream.model.FleetError]
  type FleetList = List[zio.aws.appstream.model.Fleet]
  type ImageBuilderList = List[zio.aws.appstream.model.ImageBuilder]
  type ImageList = List[zio.aws.appstream.model.Image]
  type LastReportGenerationExecutionErrors =
    List[zio.aws.appstream.model.LastReportGenerationExecutionError]
  type Metadata = Map[String, String]
  type OrganizationalUnitDistinguishedNamesList =
    List[OrganizationalUnitDistinguishedName]
  type Platforms = List[zio.aws.appstream.model.PlatformType]
  type ResourceErrors = List[zio.aws.appstream.model.ResourceError]
  type SecurityGroupIdList = List[String]
  type SessionList = List[zio.aws.appstream.model.Session]
  type SharedImagePermissionsList =
    List[zio.aws.appstream.model.SharedImagePermissions]
  type StackAttributes = List[zio.aws.appstream.model.StackAttribute]
  type StackErrors = List[zio.aws.appstream.model.StackError]
  type StackList = List[zio.aws.appstream.model.Stack]
  type StorageConnectorList = List[zio.aws.appstream.model.StorageConnector]
  type StringList = List[String]
  type SubnetIdList = List[String]
  type TagKeyList = List[TagKey]
  type Tags = Map[TagKey, TagValue]
  type UsageReportSubscriptionList =
    List[zio.aws.appstream.model.UsageReportSubscription]
  type UsbDeviceFilterStrings = List[UsbDeviceFilterString]
  type UserList = List[zio.aws.appstream.model.User]
  type UserSettingList = List[zio.aws.appstream.model.UserSetting]
  type UserStackAssociationErrorList =
    List[zio.aws.appstream.model.UserStackAssociationError]
  type UserStackAssociationList =
    List[zio.aws.appstream.model.UserStackAssociation]
}
