package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait ImageState {
  def unwrap: software.amazon.awssdk.services.appstream.model.ImageState
}
object ImageState {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.ImageState
  ): zio.aws.appstream.model.ImageState = value match {
    case software.amazon.awssdk.services.appstream.model.ImageState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.ImageState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.appstream.model.ImageState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.appstream.model.ImageState.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.appstream.model.ImageState.COPYING =>
      val r = COPYING
      r
    case software.amazon.awssdk.services.appstream.model.ImageState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.appstream.model.ImageState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.appstream.model.ImageState.IMPORTING =>
      val r = IMPORTING
      r
  }
  case object unknownToSdkVersion extends zio.aws.appstream.model.ImageState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageState =
      software.amazon.awssdk.services.appstream.model.ImageState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.appstream.model.ImageState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageState =
      software.amazon.awssdk.services.appstream.model.ImageState.PENDING
  }
  case object AVAILABLE extends zio.aws.appstream.model.ImageState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageState =
      software.amazon.awssdk.services.appstream.model.ImageState.AVAILABLE
  }
  case object FAILED extends zio.aws.appstream.model.ImageState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageState =
      software.amazon.awssdk.services.appstream.model.ImageState.FAILED
  }
  case object COPYING extends zio.aws.appstream.model.ImageState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageState =
      software.amazon.awssdk.services.appstream.model.ImageState.COPYING
  }
  case object DELETING extends zio.aws.appstream.model.ImageState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageState =
      software.amazon.awssdk.services.appstream.model.ImageState.DELETING
  }
  case object CREATING extends zio.aws.appstream.model.ImageState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageState =
      software.amazon.awssdk.services.appstream.model.ImageState.CREATING
  }
  case object IMPORTING extends zio.aws.appstream.model.ImageState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageState =
      software.amazon.awssdk.services.appstream.model.ImageState.IMPORTING
  }
}
